DF-ISE text

Info {
  version   = 1.0
  type      = xyplot
  datasets  = [
    "time"
    "Source OuterVoltage" "Source InnerVoltage" "Source QuasiFermiPotential" "Source DisplacementCurrent" "Source eCurrent"
    "Source hCurrent" "Source TotalCurrent" "Source Charge" "Gate OuterVoltage" "Gate InnerVoltage"
    "Gate QuasiFermiPotential" "Gate DisplacementCurrent" "Gate eCurrent" "Gate hCurrent" "Gate TotalCurrent"
    "Gate Charge" "Drain OuterVoltage" "Drain InnerVoltage" "Drain QuasiFermiPotential" "Drain DisplacementCurrent"
    "Drain eCurrent" "Drain hCurrent" "Drain TotalCurrent" "Drain Charge" ]
  functions = [
    Time
    OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent eCurrent
    hCurrent TotalCurrent Charge OuterVoltage InnerVoltage
    QuasiFermiPotential DisplacementCurrent eCurrent hCurrent TotalCurrent
    Charge OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent
    eCurrent hCurrent TotalCurrent Charge ]
}

Data {
      5.00000000000000E-10
      0.00000000000000E+00  -1.09275949882143E-11   0.00000000000000E+00  -1.13598892704479E-13   1.47974947561950E-22
      1.09276431119068E-08   1.09275295130142E-08  -7.99416023833534E-19  -2.46304709481801E-01  -2.46304709481827E-01
      0.00000000000000E+00   0.00000000000000E+00   2.57730110060844E-11   0.00000000000000E+00   2.57730110060844E-11
      3.71361512117044E-18  -2.46304709481801E-01  -2.42853835801530E-01   0.00000000000000E+00   1.25917340441892E-13
     -9.82500733703844E-23  -1.09534284413607E-08  -1.09533025240203E-08  -2.91419909733691E-18
      1.17500000000000E-09
      0.00000000000000E+00  -9.88047313931131E-12   0.00000000000000E+00  -7.70444283651763E-14   1.35419981015927E-22
      9.88050970492216E-09   9.88043266049393E-09  -8.08679659960903E-19  -2.42051569355066E-01  -2.42051569355093E-01
      0.00000000000000E+00   0.00000000000000E+00   2.71332099231736E-11   0.00000000000000E+00   2.71332099231736E-11
      3.73193003786859E-18  -2.42051569355066E-01  -2.38930159062339E-01   0.00000000000000E+00   1.06144963450206E-13
     -9.81120347928358E-23  -9.90767201538045E-09  -9.90756587041710E-09  -2.92325037790768E-18
      2.08625000000000E-09
      0.00000000000000E+00  -8.88974395905372E-12   0.00000000000000E+00   4.41320672684404E-13   1.26249044424020E-22
      8.88982426920430E-09   8.89026558987711E-09  -8.18666931020441E-19  -2.37256267338109E-01  -2.37256267338136E-01
      0.00000000000000E+00   0.00000000000000E+00   2.66401452535756E-11   0.00000000000000E+00   2.66401452535756E-11
      3.75620587023090E-18  -2.37256267338218E-01  -2.34447122388839E-01   0.00000000000000E+00  -4.05059272720233E-13
     -9.79152091649570E-23  -8.91650067585787E-09  -8.91690573513069E-09  -2.93753893921046E-18
      3.31643750000000E-09
      0.00000000000000E+00  -7.97340901593423E-12   0.00000000000000E+00   5.00266684724102E-13   1.20341416393576E-22
      7.97342706517303E-09   7.97392733185788E-09  -8.29223136726379E-19  -2.31974899935381E-01  -2.31974899935405E-01
      0.00000000000000E+00   0.00000000000000E+00   2.45542838263901E-11   0.00000000000000E+00   2.45542838263901E-11
      3.78641224326558E-18  -2.31974899935074E-01  -2.29455119571732E-01   0.00000000000000E+00  -4.61883732269501E-13
     -9.76578583515324E-23  -7.99801973195190E-09  -7.99848161568426E-09  -2.95718910653920E-18
      4.97719062500000E-09
      0.00000000000000E+00  -7.14230598894332E-12   0.00000000000000E+00  -2.49511028635392E-14   1.17290148343814E-22
      7.14231600743387E-09   7.14229105633113E-09  -8.40153686401786E-19  -2.26319232763859E-01  -2.26319232763880E-01
      0.00000000000000E+00   0.00000000000000E+00   2.12451343441586E-11   0.00000000000000E+00   2.12451343441586E-11
      3.82169516651869E-18  -2.26319232763525E-01  -2.24062334577329E-01   0.00000000000000E+00   6.15801352461265E-14
     -9.73477249675254E-23  -7.16359777081044E-09  -7.16353619067529E-09  -2.98154148011690E-18
      7.21920734375000E-09
      0.00000000000000E+00  -6.40304769915994E-12   0.00000000000000E+00  -1.64646063276749E-14   1.16465683246833E-22
      6.40312369206936E-09   6.40310722746315E-09  -8.51180715035479E-19  -2.20472430859288E-01  -2.20472430859306E-01
      0.00000000000000E+00   0.00000000000000E+00   1.72031219376663E-11   0.00000000000000E+00   1.72031219376663E-11
      3.86026485351763E-18  -2.20472430858956E-01  -2.18449687329877E-01   0.00000000000000E+00   4.69251540609656E-14
     -9.70041774279385E-23  -6.42035727455477E-09  -6.42031034940081E-09  -3.00908413848215E-18
      1.02459299140625E-08
      0.00000000000000E+00  -5.76233881240023E-12   0.00000000000000E+00  -1.05893878325589E-14   1.17123520906522E-22
      5.76239269269308E-09   5.76238210330537E-09  -8.61914758791230E-19  -2.14693458931760E-01  -2.14693458931773E-01
      0.00000000000000E+00   0.00000000000000E+00   1.29705876850218E-11   0.00000000000000E+00   1.29705876850218E-11
      3.89952322401410E-18  -2.14693458931561E-01  -2.12873910578944E-01   0.00000000000000E+00   3.34141724623523E-14
     -9.66557934093570E-23  -5.77538610516275E-09  -5.77535269099039E-09  -3.03760846522287E-18
      1.43320053839844E-08
      0.00000000000000E+00  -5.22670030500593E-12   0.00000000000000E+00  -6.56829246403123E-15   1.18549438971625E-22
      5.22674035430255E-09   5.22673378601021E-09  -8.71856379051434E-19  -2.09300890690585E-01  -2.09300890690594E-01
      0.00000000000000E+00   0.00000000000000E+00   9.04462043601110E-12   0.00000000000000E+00   9.04462043601110E-12
      3.93648022571244E-18  -2.09300890690393E-01  -2.07651336409959E-01   0.00000000000000E+00   2.20094441155459E-14
     -9.63339682924599E-23  -5.23580041589025E-09  -5.23577840644623E-09  -3.06462384666101E-18
      1.93320053839844E-08
      0.00000000000000E+00  -4.82735938762761E-12   0.00000000000000E+00  -4.00831612446443E-15   1.20059619444422E-22
      4.82733869462228E-09   4.82733468630627E-09  -8.79920421744895E-19  -2.04918302155823E-01  -2.04918302155829E-01
      0.00000000000000E+00   0.00000000000000E+00   5.97971234196218E-12   0.00000000000000E+00   5.97971234196218E-12
      3.96637878742225E-18  -2.04918302155683E-01  -2.03395545165521E-01   0.00000000000000E+00   1.37876129881705E-14
     -9.60808874625551E-23  -4.83332818626114E-09  -4.83331439864825E-09  -3.08645836567736E-18
      2.43320053839844E-08
      0.00000000000000E+00  -4.57294946556276E-12   0.00000000000000E+00   1.49059425194503E-13   1.21194403253456E-22
      4.57300094282924E-09   4.57315000225456E-09  -8.85376491544791E-19  -2.01955532772853E-01  -2.01955532772857E-01
      0.00000000000000E+00   0.00000000000000E+00   4.00404025094649E-12   0.00000000000000E+00   4.00404025094649E-12
      3.98639898867699E-18  -2.01955532767042E-01  -2.00513527511662E-01   0.00000000000000E+00  -1.43417996634225E-13
     -9.59157947065955E-23  -4.57701062450877E-09  -4.57715404250550E-09  -3.10102249713219E-18
      2.93320053839844E-08
      0.00000000000000E+00  -4.40579204384506E-12   0.00000000000000E+00   6.20690684857863E-14   1.22002956601696E-22
      4.40579465191569E-09   4.40585672098430E-09  -8.89112976566255E-19  -1.99930064360422E-01  -1.99930064360424E-01
      0.00000000000000E+00   0.00000000000000E+00   2.71006167851472E-12   0.00000000000000E+00   2.71006167851472E-12
      3.99994929706956E-18  -1.99930064361720E-01  -1.98541145362096E-01   0.00000000000000E+00  -5.82142257404940E-14
     -9.58073856857260E-23  -4.40850856843698E-09  -4.40856678266282E-09  -3.11083632050330E-18
      3.43320053839844E-08
      0.00000000000000E+00  -4.29355777497746E-12   0.00000000000000E+00  -1.12886572900063E-15   1.22565599960109E-22
      4.29354986167667E-09   4.29354873281106E-09  -8.91690044170725E-19  -1.98535543521517E-01  -1.98535543521519E-01
      0.00000000000000E+00   0.00000000000000E+00   1.84977696073929E-12   0.00000000000000E+00   1.84977696073929E-12
      4.00919818187326E-18  -1.98535543526611E-01  -1.97182258471650E-01   0.00000000000000E+00   3.85377326539859E-15
     -9.57349736114988E-23  -4.29540236354496E-09  -4.29539850977180E-09  -3.11750813770253E-18
      3.93320053839844E-08
      0.00000000000000E+00  -4.21714295362080E-12   0.00000000000000E+00   3.85780891203579E-14   1.22953876702163E-22
      4.21717922989688E-09   4.21721780798612E-09  -8.93474932878687E-19  -1.97571096201343E-01  -1.97571096201345E-01
      0.00000000000000E+00   0.00000000000000E+00   1.27065693451786E-12   0.00000000000000E+00   1.27065693451786E-12
      4.01555146654584E-18  -1.97571096208852E-01  -1.96242054286760E-01   0.00000000000000E+00  -3.68812636135931E-14
     -9.56856968761103E-23  -4.21845158365693E-09  -4.21848846492064E-09  -3.12207653366716E-18
      4.43320053839844E-08
      0.00000000000000E+00  -4.16469960867530E-12   0.00000000000000E+00   2.21654951449146E-13   1.23221206492308E-22
      4.16474185296253E-09   4.16496350791410E-09  -8.94714001393806E-19  -1.96902274705896E-01  -1.96902274705897E-01
      0.00000000000000E+00   0.00000000000000E+00   8.76906399473134E-13   0.00000000000000E+00   8.76906399473134E-13
      4.01993599854321E-18  -1.96902274720391E-01  -1.95589877277640E-01   0.00000000000000E+00  -2.21180165000148E-13
     -9.56513769611287E-23  -4.16561923414848E-09  -4.16584041431358E-09  -3.12522199714941E-18
      4.93320053839844E-08
      0.00000000000000E+00  -4.12878831642716E-12   0.00000000000000E+00   8.39340926776831E-15   1.23407839231238E-22
      4.12871174480469E-09   4.12872013821408E-09  -8.95577269504400E-19  -1.96436874045860E-01  -1.96436874045860E-01
      0.00000000000000E+00   0.00000000000000E+00   6.07277724584964E-13   0.00000000000000E+00   6.07277724584964E-13
      4.02297238716613E-18  -1.96436874066690E-01  -1.95135912991050E-01   0.00000000000000E+00  -7.56865356867340E-15
     -9.56293012538924E-23  -4.12931984728500E-09  -4.12932741593867E-09  -3.12739511766174E-18
      5.43320053839844E-08
      0.00000000000000E+00  -4.10362285843230E-12   0.00000000000000E+00   4.99528273378279E-14   1.23535512997480E-22
      4.10366242046127E-09   4.10371237328873E-09  -8.96178460337202E-19  -1.96112917088103E-01  -1.96112917088103E-01
      0.00000000000000E+00   0.00000000000000E+00   4.21718253831148E-13   0.00000000000000E+00   4.21718253831148E-13
      4.02508097843529E-18  -1.96112917116110E-01  -1.94819906324300E-01   0.00000000000000E+00  -4.95224018766515E-14
     -9.56132412174306E-23  -4.10408456914058E-09  -4.10413409154256E-09  -3.12890251809808E-18
      5.93320053839844E-08
      0.00000000000000E+00  -4.08626420310007E-12   0.00000000000000E+00  -1.74941430115982E-16   1.23624601454022E-22
      4.08630410210599E-09   4.08630392716469E-09  -8.96597884180495E-19  -1.95887045185091E-01  -1.95887045185091E-01
      0.00000000000000E+00   0.00000000000000E+00   2.93325427995681E-13   0.00000000000000E+00   2.93325427995681E-13
      4.02654760557527E-18  -1.95887045219352E-01  -1.94599543665075E-01   0.00000000000000E+00   5.81681721938592E-16
     -9.56024608511255E-23  -4.08659783427431E-09  -4.08659725259268E-09  -3.12994972139477E-18
      6.43320053839844E-08
      0.00000000000000E+00  -4.07423254252589E-12   0.00000000000000E+00   1.16297099029754E-14   1.23686195855670E-22
      4.07420549701865E-09   4.07421712672868E-09  -8.96890420877140E-19  -1.95729541184238E-01  -1.95729541184238E-01
      0.00000000000000E+00   0.00000000000000E+00   2.04308822542981E-13   0.00000000000000E+00   2.04308822542981E-13
      4.02756914968798E-18  -1.95729541223472E-01  -1.94445879399023E-01   0.00000000000000E+00  -1.13820574088545E-14
     -9.55947693535462E-23  -4.07441005349372E-09  -4.07442143555122E-09  -3.13067872881084E-18
      6.93320053839844E-08
      0.00000000000000E+00  -4.06578282670279E-12   0.00000000000000E+00   3.95198188402636E-16   1.23729190956202E-22
      4.06578772573339E-09   4.06578812093170E-09  -8.97094639672970E-19  -1.95619621879919E-01  -1.95619621879919E-01
      0.00000000000000E+00   0.00000000000000E+00   1.42412409614936E-13   0.00000000000000E+00   1.42412409614936E-13
      4.02828121173606E-18  -1.95619621920433E-01  -1.94338631635235E-01   0.00000000000000E+00  -2.00278084827962E-16
     -9.55895067494894E-23  -4.06593033306314E-09  -4.06593053334132E-09  -3.13118657206309E-18
      7.43320053839844E-08
      0.00000000000000E+00  -4.05990476352151E-12   0.00000000000000E+00   2.71609076189015E-15   1.23759074935276E-22
      4.05991435663004E-09   4.05991707272093E-09  -8.97237188404467E-19  -1.95542905124605E-01  -1.95542905124605E-01
      0.00000000000000E+00   0.00000000000000E+00   9.93378460907432E-14   0.00000000000000E+00   9.93378460907432E-14
      4.02877790096651E-18  -1.95542905161191E-01  -1.94263778862325E-01   0.00000000000000E+00  -2.58737126201546E-15
     -9.55857949873090E-23  -4.06001382319566E-09  -4.06001641056702E-09  -3.13154071256205E-18
      7.93320053839844E-08
      0.00000000000000E+00  -4.05586359508438E-12   0.00000000000000E+00   7.23467404424376E-17   1.23779936497357E-22
      4.05581941454971E-09   4.05581948689657E-09  -8.97336731375916E-19  -1.95489341206348E-01  -1.95489341206348E-01
      0.00000000000000E+00   0.00000000000000E+00   6.93172811575880E-14   0.00000000000000E+00   6.93172811575880E-14
      4.02912448737230E-18  -1.95489341232611E-01  -1.94211514512100E-01   0.00000000000000E+00   2.26003626979563E-17
     -9.55832265662559E-23  -4.05588882677800E-09  -4.05588880417773E-09  -3.13178775599638E-18
      8.43320053839844E-08
      0.00000000000000E+00  -4.05292456349374E-12   0.00000000000000E+00   6.29224293088639E-16   1.23794473102287E-22
      4.05296060412736E-09   4.05296123335177E-09  -8.97406239291454E-19  -1.95451941279724E-01  -1.95451941279724E-01
      0.00000000000000E+00   0.00000000000000E+00   4.83858319987453E-14   0.00000000000000E+00   4.83858319987453E-14
      4.02936641653229E-18  -1.95451941288409E-01  -1.94175021836024E-01   0.00000000000000E+00  -5.64637786445451E-16
     -9.55814240779538E-23  -4.05300905454589E-09  -4.05300961918377E-09  -3.13196017724084E-18
      8.93320053839844E-08
      0.00000000000000E+00  -4.05099582401238E-12   0.00000000000000E+00   6.85589494299314E-18   1.23804623706745E-22
      4.05096551812332E-09   4.05096552497933E-09  -8.97454784382137E-19  -1.95425822682796E-01  -1.95425822682796E-01
      0.00000000000000E+00   0.00000000000000E+00   3.37809887542227E-14   0.00000000000000E+00   3.37809887542227E-14
      4.02953532147607E-18  -1.95425822665127E-01  -1.94149536369972E-01   0.00000000000000E+00   3.94346152659111E-17
     -9.55801707535983E-23  -4.05099934540261E-09  -4.05099930596809E-09  -3.13208053709393E-18
      9.43320053839844E-08
      0.00000000000000E+00  -4.04952630821706E-12   0.00000000000000E+00   1.42305055892901E-16   1.23811705519250E-22
      4.04957229984231E-09   4.04957244214749E-09  -8.97488687890410E-19  -1.95407582181983E-01  -1.95407582181983E-01
      0.00000000000000E+00   0.00000000000000E+00   2.35884697283283E-14   0.00000000000000E+00   2.35884697283283E-14
      4.02965326382471E-18  -1.95407582129151E-01  -1.94131737981275E-01   0.00000000000000E+00  -1.10382862511298E-16
     -9.55792932962047E-23  -4.04959592023426E-09  -4.04959603061722E-09  -3.13216457593430E-18
      9.93320053839844E-08
      0.00000000000000E+00  -4.04860786084499E-12   0.00000000000000E+00   1.27918306899100E-16   1.23816653796438E-22
      4.04859952135990E-09   4.04859964927833E-09  -8.97512367737822E-19  -1.95394842536090E-01  -1.95394842536090E-01
      0.00000000000000E+00   0.00000000000000E+00   1.64726927621632E-14   0.00000000000000E+00   1.64726927621632E-14
      4.02973562728852E-18  -1.95394842441880E-01  -1.94119307011651E-01   0.00000000000000E+00  -1.06044064755773E-16
     -9.55786817625236E-23  -4.04861601592693E-09  -4.04861612197109E-09  -3.13222325955069E-18
      1.04332005383984E-07
      0.00000000000000E+00  -4.04796494768453E-12   0.00000000000000E+00   3.02683346201908E-17   1.23820104587928E-22
      4.04792018859111E-09   4.04792021885957E-09  -8.97528907419750E-19  -1.95385944460452E-01  -1.95385944460452E-01
      0.00000000000000E+00   0.00000000000000E+00   1.15044147628249E-14   0.00000000000000E+00   1.15044147628249E-14
      4.02979314936233E-18  -1.95385944318558E-01  -1.94110624478781E-01   0.00000000000000E+00  -1.48142784184345E-17
     -9.55782540861050E-23  -4.04793170845995E-09  -4.04793172327433E-09  -3.13226424194258E-18
      1.09332005383984E-07
      0.00000000000000E+00  -4.04750572399850E-12   0.00000000000000E+00   2.79811731546348E-17   1.23822516290502E-22
      4.04744572304839E-09   4.04744575102969E-09  -8.97540460019211E-19  -1.95379729449868E-01  -1.95379729449868E-01
      0.00000000000000E+00   0.00000000000000E+00   8.03495413234628E-15   0.00000000000000E+00   8.03495413234628E-15
      4.02983332413299E-18  -1.95379729260623E-01  -1.94104559995146E-01   0.00000000000000E+00  -1.71325442221094E-17
     -9.55779556959079E-23  -4.04745376885118E-09  -4.04745378598382E-09  -3.13229286411378E-18
      1.14332005383984E-07
      0.00000000000000E+00  -4.04713834504967E-12   0.00000000000000E+00   1.86443562884081E-16   1.23824203039736E-22
      4.04711429530740E-09   4.04711448175109E-09  -8.97548528798604E-19  -1.95375388605408E-01  -1.95375388605408E-01
      0.00000000000000E+00   0.00000000000000E+00   5.61203707659546E-15   0.00000000000000E+00   5.61203707659546E-15
      4.02986138431838E-18  -1.95375388371511E-01  -1.94100324286347E-01   0.00000000000000E+00  -1.79796899595044E-16
     -9.55777471707544E-23  -4.04711991399117E-09  -4.04712009378817E-09  -3.13231285551977E-18
      1.19332005383984E-07
      0.00000000000000E+00  -4.04686281083804E-12   0.00000000000000E+00   5.38722564068774E-18   1.23825376635336E-22
      4.04688290450933E-09   4.04688290989668E-09  -8.97554165438965E-19  -1.95372356321843E-01  -1.95372356321843E-01
      0.00000000000000E+00   0.00000000000000E+00   3.91980837316056E-15   0.00000000000000E+00   3.91980837316056E-15
      4.02988098336024E-18  -1.95372356057584E-01  -1.94097365405772E-01   0.00000000000000E+00  -3.50773995175528E-19
     -9.55776015469413E-23  -4.04688682935419E-09  -4.04688682970506E-09  -3.13232681792128E-18
      1.24332005383984E-07
      0.00000000000000E+00  -4.04667912136363E-12   0.00000000000000E+00   4.35401812364123E-17   1.23826198208276E-22
      4.04672121755765E-09   4.04672126109795E-09  -8.97558102486217E-19  -1.95370238341078E-01  -1.95370238341078E-01
      0.00000000000000E+00   0.00000000000000E+00   2.73793003594256E-15   0.00000000000000E+00   2.73793003594256E-15
      4.02989467301042E-18  -1.95370238069482E-01  -1.94095298729725E-01   0.00000000000000E+00  -4.00393895813848E-17
     -9.55774998291480E-23  -4.04672395898851E-09  -4.04672399902799E-09  -3.13233657052421E-18
      1.29332005383984E-07
      0.00000000000000E+00  -4.04658727662642E-12   0.00000000000000E+00   7.00334084460924E-19   1.23826771190076E-22
      4.04660830617201E-09   4.04660830687247E-09  -8.97560852676710E-19  -1.95368758861367E-01  -1.95368758861367E-01
      0.00000000000000E+00   0.00000000000000E+00   1.91246622735429E-15   0.00000000000000E+00   1.91246622735429E-15
      4.02990423534156E-18  -1.95368758612974E-01  -1.94093855106253E-01   0.00000000000000E+00   1.84305936792803E-18
     -9.55774287861313E-23  -4.04661022118166E-09  -4.04661021933870E-09  -3.13234338266485E-18
      1.34332005383984E-07
      0.00000000000000E+00  -4.04649543188921E-12   0.00000000000000E+00   9.95427108025429E-18   1.23827171893901E-22
      4.04652942130368E-09   4.04652943125807E-09  -8.97562773706152E-19  -1.95367725427924E-01  -1.95367725427924E-01
      0.00000000000000E+00   0.00000000000000E+00   1.33590692561725E-15   0.00000000000000E+00   1.33590692561725E-15
      4.02991091487619E-18  -1.95367725245297E-01  -1.94092846773034E-01   0.00000000000000E+00  -8.18504325170264E-18
     -9.55773791661786E-23  -4.04653075897986E-09  -4.04653076716500E-09  -3.13234814117004E-18
      1.39332005383984E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00  -1.21529582380583E-19   1.23827451576734E-22
      4.04647432417894E-09   4.04647432405754E-09  -8.97564115653121E-19  -1.95367003519563E-01  -1.95367003519563E-01
      0.00000000000000E+00   0.00000000000000E+00   9.33203940281557E-16   0.00000000000000E+00   9.33203940281557E-16
      4.02991558089589E-18  -1.95367003453300E-01  -1.94092142466373E-01   0.00000000000000E+00   1.37620716510941E-18
     -9.55773445129180E-23  -4.04647525863759E-09  -4.04647525726148E-09  -3.13235146524277E-18
      1.44332005383984E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00   2.17109057335331E-18   1.23827647038278E-22
      4.04643583209730E-09   4.04643583426852E-09  -8.97565053088444E-19  -1.95366499218607E-01  -1.95366499218607E-01
      0.00000000000000E+00   0.00000000000000E+00   6.51932312839118E-16   0.00000000000000E+00   6.51932312839118E-16
      4.02991884055745E-18  -1.95366499325916E-01  -1.94091650554604E-01   0.00000000000000E+00  -1.29285046512697E-18
     -9.55773203153515E-23  -4.04643648490788E-09  -4.04643648620083E-09  -3.13235378746901E-18
      1.49332005383984E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00  -1.69042910514876E-19   1.23827783512227E-22
      4.04640894356367E-09   4.04640894339475E-09  -8.97565707993170E-19  -1.95366146906633E-01  -1.95366146906633E-01
      0.00000000000000E+00   0.00000000000000E+00   4.55475291666420E-16   0.00000000000000E+00   4.55475291666420E-16
      4.02992111793391E-18  -1.95366147245094E-01  -1.94091307006963E-01   0.00000000000000E+00   7.85361905358031E-19
     -9.55773034225731E-23  -4.04640939965531E-09  -4.04640939887005E-09  -3.13235540994074E-18
      1.54332005383984E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00   4.24057333737493E-19   1.23827878866428E-22
      4.04639015791351E-09   4.04639015833769E-09  -8.97566165538219E-19  -1.95365900763605E-01  -1.95365900763605E-01
      0.00000000000000E+00   0.00000000000000E+00   3.18253584674424E-16   0.00000000000000E+00   3.18253584674424E-16
      4.02992270920183E-18  -1.95365901384232E-01  -1.94091067107786E-01   0.00000000000000E+00   1.13951700563997E-20
     -9.55772916334517E-23  -4.04639047660257E-09  -4.04639047659127E-09  -3.13235654366362E-18
      1.59332005383984E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00  -1.07440044184619E-19   1.23827945475936E-22
      4.04637703418488E-09   4.04637703407756E-09  -8.97566485212668E-19  -1.95365728787015E-01  -1.95365728787015E-01
      0.00000000000000E+00   0.00000000000000E+00   2.22396009951590E-16   0.00000000000000E+00   2.22396009951590E-16
      4.02992382118188E-18  -1.95365729724760E-01  -1.94090899613172E-01   0.00000000000000E+00   4.10083470942735E-19
     -9.55772834091465E-23  -4.04637725688356E-09  -4.04637725647358E-09  -3.13235733596922E-18
      1.64332005383984E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00   5.12432883044220E-20   1.23827992045883E-22
      4.04636786612201E-09   4.04636786617337E-09  -8.97566708548599E-19  -1.95365608633761E-01  -1.95365608633761E-01
      0.00000000000000E+00   0.00000000000000E+00   1.55416633665373E-16   0.00000000000000E+00   1.55416633665373E-16
      4.02992459826505E-18  -1.95365609896422E-01  -1.94090782694352E-01   0.00000000000000E+00   1.60064579078150E-19
     -9.55772776738444E-23  -4.04636802174998E-09  -4.04636802159001E-09  -3.13235788971645E-18
      1.69332005383984E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -5.75748019641348E-20   1.23828024636013E-22
      4.04636146353288E-09   4.04636146347543E-09  -8.97566864538395E-19  -1.95365524707099E-01  -1.95365524707099E-01
      0.00000000000000E+00   0.00000000000000E+00   1.08589649590857E-16   0.00000000000000E+00   1.08589649590857E-16
      4.02992514121330E-18  -1.95365526262859E-01  -1.94090701092690E-01   0.00000000000000E+00   2.03993798635141E-19
     -9.55772736739985E-23  -4.04636157226898E-09  -4.04636157206508E-09  -3.13235827667491E-18
      1.74332005383984E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -1.27494409590621E-20   1.23828047494691E-22
      4.04635699531480E-09   4.04635699530217E-09  -8.97566973412480E-19  -1.95365466124054E-01  -1.95365466124054E-01
      0.00000000000000E+00   0.00000000000000E+00   7.58185712426625E-17   0.00000000000000E+00   7.58185712426625E-17
      4.02992552030615E-18  -1.95365467889400E-01  -1.94090644137277E-01   0.00000000000000E+00   1.12651838249254E-19
     -9.55772708814559E-23  -4.04635707123330E-09  -4.04635707112074E-09  -3.13235854689368E-18
      1.79332005383984E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -3.04569216441443E-20   1.23828063583929E-22
      4.04635388178897E-09   4.04635388175863E-09  -8.97567049282615E-19  -1.95365425293701E-01  -1.95365425293701E-01
      0.00000000000000E+00   0.00000000000000E+00   5.28438628146820E-17   0.00000000000000E+00   5.28438628146820E-17
      4.02992578452547E-18  -1.95365427122968E-01  -1.94090604359005E-01   0.00000000000000E+00   1.01162024682776E-19
     -9.55772689248405E-23  -4.04635393470356E-09  -4.04635393460250E-09  -3.13235873524286E-18
      1.84332005383984E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -1.49527601622796E-20   1.23828074971779E-22
      4.04635171837406E-09   4.04635171835923E-09  -8.97567101991146E-19  -1.95365396922416E-01  -1.95365396922416E-01
      0.00000000000000E+00   0.00000000000000E+00   3.66927709067968E-17   0.00000000000000E+00   3.66927709067968E-17
      4.02992596798932E-18  -1.95365398601280E-01  -1.94090576523994E-01   0.00000000000000E+00   6.42286522161424E-20
     -9.55772675426526E-23  -4.04635175511613E-09  -4.04635175505200E-09  -3.13235886599818E-18
      1.89332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -1.43222606434506E-20   1.23828083092901E-22
      4.04635022262715E-09   4.04635022261295E-09  -8.97567138405867E-19  -1.95365377317347E-01  -1.95365377317347E-01
      0.00000000000000E+00   0.00000000000000E+00   2.52940457963561E-17   0.00000000000000E+00   2.52940457963561E-17
      4.02992609445955E-18  -1.95365378562602E-01  -1.94090556960145E-01   0.00000000000000E+00   5.10320549630884E-20
     -9.55772665502306E-23  -4.04635024795793E-09  -4.04635024790700E-09  -3.13235895605369E-18
      1.94332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -8.75246721460737E-21   1.23828088935317E-22
      4.04634919685678E-09   4.04634919684815E-09  -8.97567163329488E-19  -1.95365363897203E-01  -1.95365363897203E-01
      0.00000000000000E+00   0.00000000000000E+00   1.72107987160884E-17   0.00000000000000E+00   1.72107987160884E-17
      4.02992618051355E-18  -1.95365364365554E-01  -1.94090543088814E-01   0.00000000000000E+00   3.65049619886476E-20
     -9.55772658174695E-23  -4.04634921409535E-09  -4.04634921405895E-09  -3.13235901718406E-18
      1.99332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -8.01817988520970E-21   1.23828093167879E-22
      4.04634850197924E-09   4.04634850197135E-09  -8.97567180138583E-19  -1.95365354848446E-01  -1.95365354848446E-01
      0.00000000000000E+00   0.00000000000000E+00   1.14534143373378E-17   0.00000000000000E+00   1.14534143373378E-17
      4.02992623778062E-18  -1.95365354156811E-01  -1.94090533100807E-01   0.00000000000000E+00   3.01391572020949E-20
     -9.55772652534266E-23  -4.04634851345481E-09  -4.04634851342476E-09  -3.13235905764203E-18
      2.04332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -5.03302299004325E-21   1.23828096230416E-22
      4.04634803906474E-09   4.04634803905984E-09  -8.97567191234470E-19  -1.95365348882602E-01  -1.95365348882602E-01
      0.00000000000000E+00   0.00000000000000E+00   7.34953582471309E-18   0.00000000000000E+00   7.34953582471309E-18
      4.02992627452830E-18  -1.95365346642077E-01  -1.94090525733207E-01   0.00000000000000E+00   2.21150335215663E-20
     -9.55772647962528E-23  -4.04634804643140E-09  -4.04634804640938E-09  -3.13235908329383E-18
      2.09332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -2.21337793375721E-21   1.23828098397351E-22
      4.04634773640703E-09   4.04634773640494E-09  -8.97567198360643E-19  -1.95365345065208E-01  -1.95365345065208E-01
      0.00000000000000E+00   0.00000000000000E+00   4.45219636510326E-18   0.00000000000000E+00   4.45219636510326E-18
      4.02992629678928E-18  -1.95365340929832E-01  -1.94090520117227E-01   0.00000000000000E+00   1.84609710455102E-20
     -9.55772644064929E-23  -4.04634774087550E-09  -4.04634774085714E-09  -3.13235909842863E-18
      2.14332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -2.14891061529826E-21   1.23828099824302E-22
      4.04634754046216E-09   4.04634754046014E-09  -8.97567202825891E-19  -1.95365342695401E-01  -1.95365342695401E-01
      0.00000000000000E+00   0.00000000000000E+00   2.47463234811102E-18   0.00000000000000E+00   2.47463234811102E-18
      4.02992630916244E-18  -1.95365336425463E-01  -1.94090515675214E-01   0.00000000000000E+00   1.67061797813581E-20
     -9.55772640628713E-23  -4.04634754295138E-09  -4.04634754293477E-09  -3.13235910633655E-18
      2.19332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -6.07181552577892E-22   1.23828100584064E-22
      4.04634740962559E-09   4.04634740962511E-09  -8.97567205658107E-19  -1.95365341222626E-01  -1.95365341222626E-01
      0.00000000000000E+00   0.00000000000000E+00   1.24225784472794E-18   0.00000000000000E+00   1.24225784472794E-18
      4.02992631537373E-18  -1.95365332760164E-01  -1.94090512051523E-01   0.00000000000000E+00   1.42989426771995E-20
     -9.55772637595240E-23  -4.04634741088157E-09  -4.04634741086737E-09  -3.13235910971562E-18
      2.24332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -1.43611239205358E-21   1.23828100696471E-22
      4.04634731014724E-09   4.04634731014593E-09  -8.97567207706425E-19  -1.95365340191060E-01  -1.95365340191060E-01
      0.00000000000000E+00   0.00000000000000E+00   6.56050629986273E-19   0.00000000000000E+00   6.56050629986273E-19
      4.02992631865398E-18  -1.95365329742687E-01  -1.94090509065571E-01   0.00000000000000E+00   1.19868062981435E-20
     -9.55772635040216E-23  -4.04634731081387E-09  -4.04634731080197E-09  -3.13235911094756E-18
      2.29332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -2.12376378894903E-21   1.23828100155422E-22
      4.04634721366925E-09   4.04634721366725E-09  -8.97567209702349E-19  -1.95365339205994E-01  -1.95365339205994E-01
      0.00000000000000E+00   0.00000000000000E+00   6.62663529478931E-19   0.00000000000000E+00   6.62663529478931E-19
      4.02992632196730E-18  -1.95365327325167E-01  -1.94090506678445E-01   0.00000000000000E+00   9.64998030776279E-21
     -9.55772633155444E-23  -4.04634721433947E-09  -4.04634721432991E-09  -3.13235911226495E-18
      2.34332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -1.18281526846311E-21   1.23828098954917E-22
      4.04634709611522E-09   4.04634709611416E-09  -8.97567212287342E-19  -1.95365337918256E-01  -1.95365337918256E-01
      0.00000000000000E+00   0.00000000000000E+00   1.22861466986791E-18   0.00000000000000E+00   1.22861466986791E-18
      4.02992632811037E-18  -1.95365325575941E-01  -1.94090504966075E-01   0.00000000000000E+00   4.20272050549396E-21
     -9.55772632227140E-23  -4.04634709734688E-09  -4.04634709734277E-09  -3.13235911582303E-18
      2.39332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -1.14075148620620E-21   1.23828097115030E-22
      4.04634693768686E-09   4.04634693768584E-09  -8.97567216011598E-19  -1.95365336024208E-01  -1.95365336024208E-01
      0.00000000000000E+00   0.00000000000000E+00   2.31673247995941E-18   0.00000000000000E+00   2.31673247995941E-18
      4.02992633969404E-18  -1.95365324653827E-01  -1.94090504093532E-01   0.00000000000000E+00  -6.09924842725081E-22
     -9.55772632606084E-23  -4.04634694000187E-09  -4.04634694000258E-09  -3.13235912368244E-18
      2.44332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -1.81194314221851E-21   1.23828094707620E-22
      4.04634672377606E-09   4.04634672377437E-09  -8.97567221308035E-19  -1.95365333279270E-01  -1.95365333279270E-01
      0.00000000000000E+00   0.00000000000000E+00   3.86425799328372E-18   0.00000000000000E+00   3.86425799328372E-18
      4.02992635901533E-18  -1.95365324779379E-01  -1.94090504285991E-01   0.00000000000000E+00  -8.06344417263833E-21
     -9.55772634666620E-23  -4.04634672763047E-09  -4.04634672763863E-09  -3.13235913770729E-18
      2.49332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -3.14198164858078E-21   1.23828091880538E-22
      4.04634644662439E-09   4.04634644662137E-09  -8.97567228445594E-19  -1.95365329522913E-01  -1.95365329522913E-01
      0.00000000000000E+00   0.00000000000000E+00   5.76290113438159E-18   0.00000000000000E+00   5.76290113438159E-18
      4.02992638782983E-18  -1.95365326199790E-01  -1.94090505793124E-01   0.00000000000000E+00  -1.37146218758482E-20
     -9.55772638751760E-23  -4.04634645237046E-09  -4.04634645238427E-09  -3.13235915938424E-18
      2.54332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -3.31023677760839E-21   1.23828088878208E-22
      4.04634610749146E-09   4.04634610748827E-09  -8.97567237467037E-19  -1.95365324712487E-01  -1.95365324712487E-01
      0.00000000000000E+00   0.00000000000000E+00   7.84188829066904E-18   0.00000000000000E+00   7.84188829066904E-18
      4.02992642703927E-18  -1.95365329145279E-01  -1.94090508844805E-01   0.00000000000000E+00  -2.70685010973411E-20
     -9.55772645104605E-23  -4.04634611530299E-09  -4.04634611533016E-09  -3.13235918957224E-18
      2.59332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -2.94400754295862E-21   1.23828086055898E-22
      4.04634571907343E-09   4.04634571907061E-09  -8.97567248117776E-19  -1.95365318962496E-01  -1.95365318962496E-01
      0.00000000000000E+00   0.00000000000000E+00   9.85555308088506E-18   0.00000000000000E+00   9.85555308088506E-18
      4.02992647631704E-18  -1.95365333776228E-01  -1.94090513597495E-01   0.00000000000000E+00  -3.78670055467271E-20
     -9.55772653787035E-23  -4.04634572888820E-09  -4.04634572892616E-09  -3.13235922819926E-18
      2.64332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -3.16347075473376E-21   1.23828083876629E-22
      4.04634530742042E-09   4.04634530741738E-09  -8.97567259784105E-19  -1.95365312579899E-01  -1.95365312579899E-01
      0.00000000000000E+00   0.00000000000000E+00   1.14844476018601E-17   0.00000000000000E+00   1.14844476018601E-17
      4.02992653373928E-18  -1.95365340123747E-01  -1.94090520074196E-01   0.00000000000000E+00  -4.41235359424167E-20
     -9.55772664596207E-23  -4.04634531885761E-09  -4.04634531890183E-09  -3.13235927395518E-18
      2.69332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -2.54636763612353E-20   1.23828082902407E-22
      4.04634491348396E-09   4.04634491345862E-09  -8.97567271438547E-19  -1.95365306096139E-01  -1.95365306096139E-01
      0.00000000000000E+00   0.00000000000000E+00   1.23371707944051E-17   0.00000000000000E+00   1.23371707944051E-17
      4.02992659542513E-18  -1.95365348025775E-01  -1.94090528100070E-01   0.00000000000000E+00  -2.21301216173758E-20
     -9.55772676959724E-23  -4.04634492577356E-09  -4.04634492579579E-09  -3.13235932398659E-18
      2.74332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00   3.27123633601584E-19   1.23828083701159E-22
      4.04634458968023E-09   4.04634459000747E-09  -8.97567281693635E-19  -1.95365300243396E-01  -1.95365300243396E-01
      0.00000000000000E+00   0.00000000000000E+00   1.20340338478990E-17   0.00000000000000E+00   1.20340338478990E-17
      4.02992665559530E-18  -1.95365357082064E-01  -1.94090537258474E-01   0.00000000000000E+00  -3.73489352024304E-19
     -9.55772689789266E-23  -4.04634460166792E-09  -4.04634460204151E-09  -3.13235937390167E-18
      2.76832005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -1.80432132752465E-15   1.23828040567229E-22
      4.04634192883858E-09   4.04634012451737E-09  -8.97567358760754E-19  -1.95365263598726E-01  -1.95365263598726E-01
      0.00000000000000E+00   0.00000000000000E+00   8.55378303831862E-17   0.00000000000000E+00   8.55378303831862E-17
      4.02992686943988E-18  -1.95365367805595E-01  -1.94090548796611E-01   0.00000000000000E+00   1.81735410554884E-15
     -9.55807106524030E-23  -4.04634202740921E-09  -4.04634021005520E-09  -3.13235951067912E-18
      2.77675755383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00   1.61908527272086E-19   1.23828109347217E-22
      4.04634464672652E-09   4.04634464688855E-09  -8.97567289021826E-19  -1.95365294894267E-01  -1.95365294894267E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.54040962292319E-16   0.00000000000000E+00  -1.54040962292319E-16
      4.02992673946782E-18  -1.95365369310516E-01  -1.94090549521228E-01   0.00000000000000E+00   6.75170341155781E-19
     -9.55772715508259E-23  -4.04634449352266E-09  -4.04634449284759E-09  -3.13235945044599E-18
      2.78814817883985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00   1.84558959587379E-19   1.23828237377310E-22
      4.04634884011832E-09   4.04634884030301E-09  -8.97567194869482E-19  -1.95365339049181E-01  -1.95365339049181E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.09421121287994E-16   0.00000000000000E+00  -2.09421121287994E-16
      4.02992650092407E-18  -1.95365366688855E-01  -1.94090545595848E-01   0.00000000000000E+00   6.84333844677443E-19
     -9.55772691139489E-23  -4.04634863156612E-09  -4.04634863088189E-09  -3.13235930605459E-18
      2.80352552258985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00   1.73438118545698E-19   1.23828355491329E-22
      4.04635413575058E-09   4.04635413592414E-09  -8.97567068840138E-19  -1.95365401091142E-01  -1.95365401091142E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.58049502830962E-16   0.00000000000000E+00  -2.58049502830962E-16
      4.02992610411248E-18  -1.95365355310778E-01  -1.94090532564665E-01   0.00000000000000E+00   7.66739537408861E-19
     -9.55772598376481E-23  -4.04635387864129E-09  -4.04635387787464E-09  -3.13235903527234E-18
      2.82428493665235E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00   1.63892383263529E-19   1.23828460284504E-22
      4.04636091425825E-09   4.04636091442227E-09  -8.97566899380631E-19  -1.95365488003069E-01  -1.95365488003069E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.01747566897735E-16   0.00000000000000E+00  -3.01747566897735E-16
      4.02992547770221E-18  -1.95365326666888E-01  -1.94090501798921E-01   0.00000000000000E+00   8.88975517002345E-19
     -9.55772504299454E-23  -4.04636061356358E-09  -4.04636061267470E-09  -3.13235857832158E-18
      2.85231014563672E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00   1.56799149372946E-19   1.23828548503761E-22
      4.04636965984519E-09   4.04636966000211E-09  -8.97566670618887E-19  -1.95365608961503E-01  -1.95365608961503E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.40355843313026E-16   0.00000000000000E+00  -3.40355843313026E-16
      4.02992452384785E-18  -1.95365265499345E-01  -1.94090437888166E-01   0.00000000000000E+00   1.05764122512198E-18
     -9.55772356729651E-23  -4.04636932070382E-09  -4.04636931964627E-09  -3.13235785322896E-18
      2.89014417776563E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00   1.47487508183337E-19   1.23828614512097E-22
      4.04638076753333E-09   4.04638076768094E-09  -8.97566366428539E-19  -1.95365773660255E-01  -1.95365773660255E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.70700323565180E-16   0.00000000000000E+00  -3.70700323565180E-16
      4.02992312133905E-18  -1.95365145874359E-01  -1.94090314773153E-01   0.00000000000000E+00   1.26324442064348E-18
     -9.55772123162546E-23  -4.04638039824376E-09  -4.04638039698062E-09  -3.13235675491051E-18
      2.94014417776563E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00   1.29939595541816E-19   1.23828635875044E-22
      4.04639344959181E-09   4.04639344972188E-09  -8.97565998182513E-19  -1.95365977986435E-01  -1.95365977986435E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.78031238034152E-16   0.00000000000000E+00  -3.78031238034152E-16
      4.02992123118286E-18  -1.95364935453394E-01  -1.94090100358871E-01   0.00000000000000E+00   1.45487055286504E-18
     -9.55771774464806E-23  -4.04639307314542E-09  -4.04639307169064E-09  -3.13235523300035E-18
      2.99014417776563E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00   9.88576609591371E-20   1.23828591791015E-22
      4.04640282183666E-09   4.04640282193564E-09  -8.97565701325562E-19  -1.95366148062133E-01  -1.95366148062133E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.47306692317664E-16   0.00000000000000E+00  -3.47306692317664E-16
      4.02991949464940E-18  -1.95364690663959E-01  -1.94089852606904E-01   0.00000000000000E+00   1.50981865451324E-18
     -9.55771417376222E-23  -4.04640247613867E-09  -4.04640247462895E-09  -3.13235379332384E-18
      3.04014417776563E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00   5.10343410382110E-20   1.23828473430830E-22
      4.04640717752440E-09   4.04640717757556E-09  -8.97565524011976E-19  -1.95366257572305E-01  -1.95366257572305E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.69504915647767E-16   0.00000000000000E+00  -2.69504915647767E-16
      4.02991814712482E-18  -1.95364436631459E-01  -1.94089597177547E-01   0.00000000000000E+00   1.38219165256550E-18
     -9.55771095325788E-23  -4.04640690945275E-09  -4.04640690807065E-09  -3.13235262311285E-18
      3.09014417776563E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00  -1.14189452376753E-20   1.23828270213126E-22
      4.04640454307919E-09   4.04640454306789E-09  -8.97565522676762E-19  -1.95366275579784E-01  -1.95366275579784E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.35245720363595E-16   0.00000000000000E+00  -1.35245720363595E-16
      4.02991747089622E-18  -1.95364206563827E-01  -1.94089367897573E-01   0.00000000000000E+00   1.02399660032680E-18
     -9.55770863263524E-23  -4.04640440884608E-09  -4.04640440782217E-09  -3.13235194821946E-18
      3.14014417776563E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00   5.11202974628230E-20   1.23827974539114E-22
      4.04639286147467E-09   4.04639286152592E-09  -8.97565757856969E-19  -1.95366168536145E-01  -1.95366168536145E-01
      0.00000000000000E+00   0.00000000000000E+00   6.25640771466107E-17   0.00000000000000E+00   6.25640771466107E-17
      4.02991778371661E-18  -1.95364041770892E-01  -1.94089206722670E-01   0.00000000000000E+00   2.47939477933015E-19
     -9.55770785959376E-23  -4.04639292433784E-09  -4.04639292408999E-09  -3.13235202585964E-18
      3.19014417776563E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00  -1.48056283673854E-19   1.23827585908634E-22
      4.04637025780880E-09   4.04637025766087E-09  -8.97566287570465E-19  -1.95365903685393E-01  -1.95365903685393E-01
      0.00000000000000E+00   0.00000000000000E+00   3.26083443845359E-16   0.00000000000000E+00   3.26083443845359E-16
      4.02991941413382E-18  -1.95363990440255E-01  -1.94089162430477E-01   0.00000000000000E+00  -5.86097996151669E-19
     -9.55770934200633E-23  -4.04637058315812E-09  -4.04637058374431E-09  -3.13235312656336E-18
      3.24014417776563E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00   2.60572329060822E-19   1.23827114963215E-22
      4.04633539127913E-09   4.04633539153983E-09  -8.97567158104351E-19  -1.95365453919050E-01  -1.95365453919050E-01
      0.00000000000000E+00   0.00000000000000E+00   6.49781102023108E-16   0.00000000000000E+00   6.49781102023108E-16
      4.02992266303933E-18  -1.95364104820378E-01  -1.94089287693637E-01   0.00000000000000E+00  -2.35791457617222E-18
     -9.55771378449401E-23  -4.04633603896292E-09  -4.04633604132093E-09  -3.13235550493498E-18
      3.29014417776563E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -3.59080220526192E-19   1.23826587267646E-22
      4.04628788333188E-09   4.04628788297292E-09  -8.97568392479175E-19  -1.95364803956692E-01  -1.95364803956692E-01
      0.00000000000000E+00   0.00000000000000E+00   1.01775028425861E-15   0.00000000000000E+00   1.01775028425861E-15
      4.02992775179075E-18  -1.95364436528919E-01  -1.94089634254102E-01   0.00000000000000E+00  -3.34578707462581E-18
     -9.55772179713529E-23  -4.04628889737733E-09  -4.04628890072321E-09  -3.13235935931158E-18
      3.34014417776563E-07
      0.00000000000000E+00  -4.04621989767759E-12   0.00000000000000E+00   2.33530803649928E-19   1.23826046540990E-22
      4.04622879161014E-09   4.04622879184379E-09  -8.97569977164743E-19  -1.95363957559134E-01  -1.95363957559134E-01
      0.00000000000000E+00   0.00000000000000E+00   1.40138846605275E-15   0.00000000000000E+00   1.40138846605275E-15
      4.02993475873309E-18  -1.95365029853322E-01  -1.94090246075112E-01   0.00000000000000E+00  -5.77308357355567E-18
     -9.55773377782116E-23  -4.04623018745908E-09  -4.04623019323226E-09  -3.13236478156834E-18
      3.39014417776563E-07
      0.00000000000000E+00  -4.04621989767759E-12   0.00000000000000E+00  -6.03302997524791E-19   1.23825556539574E-22
      4.04616109103417E-09   4.04616109043099E-09  -8.97571848207614E-19  -1.95362945185983E-01  -1.95362945185983E-01
      0.00000000000000E+00   0.00000000000000E+00   1.75786415882774E-15   0.00000000000000E+00   1.75786415882774E-15
      4.02994354805388E-18  -1.95365913109407E-01  -1.94091150548713E-01   0.00000000000000E+00  -6.69013072141918E-18
     -9.55774977207926E-23  -4.04616284160493E-09  -4.04616284829516E-09  -3.13237169984626E-18
      3.44014417776563E-07
      0.00000000000000E+00  -4.04612805294038E-12   0.00000000000000E+00  -3.07052808454699E-19   1.23825201141803E-22
      4.04609009145650E-09   4.04609009114957E-09  -8.97573878305228E-19  -1.95361831281175E-01  -1.95361831281175E-01
      0.00000000000000E+00   0.00000000000000E+00   2.02989213918743E-15   0.00000000000000E+00   2.02989213918743E-15
      4.02995369751457E-18  -1.95367088434136E-01  -1.94092348157006E-01   0.00000000000000E+00  -8.61413818058042E-18
     -9.55776932157706E-23  -4.04609211242748E-09  -4.04609212104171E-09  -3.13237981920935E-18
      3.49014417776563E-07
      0.00000000000000E+00  -4.04603620820318E-12   0.00000000000000E+00  -6.73667475370146E-19   1.23825081556740E-22
      4.04602372195463E-09   4.04602372128109E-09  -8.97575867001842E-19  -1.95360720042157E-01  -1.95360720042157E-01
      0.00000000000000E+00   0.00000000000000E+00   2.14730898433768E-15   0.00000000000000E+00   2.14730898433768E-15
      4.02996443405950E-18  -1.95368520722307E-01  -1.94093801318763E-01   0.00000000000000E+00  -9.25439009588268E-18
     -9.55779131462754E-23  -4.04602585933559E-09  -4.04602586859008E-09  -3.13238856705766E-18
      3.54014417776563E-07
      0.00000000000000E+00  -4.04594436346597E-12   0.00000000000000E+00  -4.44640239711854E-19   1.23825310234336E-22
      4.04597257880665E-09   4.04597257836213E-09  -8.97577536527702E-19  -1.95359758302347E-01  -1.95359758302347E-01
      0.00000000000000E+00   0.00000000000000E+00   2.03105368912008E-15   0.00000000000000E+00   2.03105368912008E-15
      4.02997458932794E-18  -1.95370126837719E-01  -1.94095423584223E-01   0.00000000000000E+00  -9.69123573385632E-18
     -9.55781386203391E-23  -4.04597459972449E-09  -4.04597460941582E-09  -3.13239705280024E-18
      3.59014417776563E-07
      0.00000000000000E+00  -4.04594436346597E-12   0.00000000000000E+00   1.30967872131987E-19   1.23826000595152E-22
      4.04594964172811E-09   4.04594964185920E-09  -8.97578536212375E-19  -1.95359133937421E-01  -1.95359133937421E-01
      0.00000000000000E+00   0.00000000000000E+00   1.59993710976708E-15   0.00000000000000E+00   1.59993710976708E-15
      4.02998258901349E-18  -1.95371766658014E-01  -1.94097070767211E-01   0.00000000000000E+00  -9.18297128019075E-18
     -9.55783422253205E-23  -4.04595123261325E-09  -4.04595124179632E-09  -3.13240405280112E-18
      3.64014417776563E-07
      0.00000000000000E+00  -4.04594436346597E-12   0.00000000000000E+00   4.06893024501554E-18   1.23827252490329E-22
      4.04596955548120E-09   4.04596955955026E-09  -8.97578458330962E-19  -1.95359068199497E-01  -1.95359068199497E-01
      0.00000000000000E+00   0.00000000000000E+00   7.80481665586918E-16   0.00000000000000E+00   7.80481665586918E-16
      4.02998649142182E-18  -1.95373237887620E-01  -1.94098535981301E-01   0.00000000000000E+00  -1.04383099958451E-17
     -9.55784881069084E-23  -4.04597032959351E-09  -4.04597034003192E-09  -3.13240803309086E-18
      3.69014417776563E-07
      0.00000000000000E+00  -4.04603620820318E-12   0.00000000000000E+00   2.76612758044960E-18   1.23829133274001E-22
      4.04604739545219E-09   4.04604739821845E-09  -8.97576868205678E-19  -1.95359800397061E-01  -1.95359800397061E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.80131143969011E-16   0.00000000000000E+00  -4.80131143969011E-16
      4.02998409076610E-18  -1.95374276898714E-01  -1.94099550865632E-01   0.00000000000000E+00  -4.51182346611866E-18
     -9.55785331884588E-23  -4.04604691357538E-09  -4.04604691808730E-09  -3.13240722256042E-18
      3.74014417776563E-07
      0.00000000000000E+00  -4.04621989767759E-12   0.00000000000000E+00   1.84157506507239E-17   1.23831655681197E-22
      4.04619685300409E-09   4.04619687141996E-09  -8.97573350081722E-19  -1.95361563952606E-01  -1.95361563952606E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.19858945575579E-15   0.00000000000000E+00  -2.19858945575579E-15
      4.02997309781882E-18  -1.95374568031703E-01  -1.94099795452215E-01   0.00000000000000E+00  -1.36939429547187E-17
     -9.55784298403680E-23  -4.04619465913646E-09  -4.04619467283050E-09  -3.13239974773710E-18
      3.79014417776563E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00   6.89426351342178E-18   1.23834752877872E-22
      4.04642788662254E-09   4.04642789351693E-09  -8.97567569962676E-19  -1.95364553139392E-01  -1.95364553139392E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.33827670363393E-15   0.00000000000000E+00  -4.33827670363393E-15
      4.02995140643530E-18  -1.95373763463252E-01  -1.94098918768619E-01   0.00000000000000E+00   6.91974822167414E-18
     -9.55781302760800E-23  -4.04642356215988E-09  -4.04642355524023E-09  -3.13238383647262E-18
      3.84014417776563E-07
      0.00000000000000E+00  -4.04667912136363E-12   0.00000000000000E+00   3.74345002509813E-17   1.23838255518777E-22
      4.04674381333923E-09   4.04674385077385E-09  -8.97559353010618E-19  -1.95368881450727E-01  -1.95368881450727E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.79188759794746E-15   0.00000000000000E+00  -6.79188759794746E-15
      4.02991744699731E-18  -1.95371515817671E-01  -1.94096572360177E-01   0.00000000000000E+00  -1.40740834137049E-17
     -9.55775927449861E-23  -4.04673704481207E-09  -4.04673705888625E-09  -3.13235809398669E-18
      3.89014417776563E-07
      0.00000000000000E+00  -4.04713834504967E-12   0.00000000000000E+00   9.13640118665207E-18   1.23841869554946E-22
      4.04713820877511E-09   4.04713821791163E-09  -8.97548772884226E-19  -1.95374533096175E-01  -1.95374533096175E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.36671689323151E-15   0.00000000000000E+00  -9.36671689323151E-15
      4.02987061341285E-18  -1.95367523744200E-01  -1.94092456839465E-01   0.00000000000000E+00   2.72002316041340E-17
     -9.55767895643456E-23  -4.04712887839488E-09  -4.04712885119475E-09  -3.13232184052862E-18
      3.94014417776563E-07
      0.00000000000000E+00  -4.04759756873570E-12   0.00000000000000E+00   3.71944701357577E-17   1.23845166390355E-22
      4.04759159496543E-09   4.04759163216003E-09  -8.97536244335559E-19  -1.95381311720358E-01  -1.95381311720358E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17738398986252E-14   0.00000000000000E+00  -1.17738398986252E-14
      4.02981174421335E-18  -1.95361591006019E-01  -1.94086382015211E-01   0.00000000000000E+00   9.01790202545408E-18
     -9.55757165201425E-23  -4.04757986733794E-09  -4.04757985832013E-09  -3.13227549987779E-18
      3.99014417776563E-07
      0.00000000000000E+00  -4.04814863715895E-12   0.00000000000000E+00   6.09348934680181E-18   1.23847579943580E-22
      4.04806874768432E-09   4.04806875377793E-09  -8.97522610069768E-19  -1.95388791517607E-01  -1.95388791517607E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.36276480182827E-14   0.00000000000000E+00  -1.36276480182827E-14
      4.02974360597326E-18  -1.95353695376235E-01  -1.94078336636818E-01   0.00000000000000E+00   5.29807076837170E-17
     -9.55744032082692E-23  -4.04805517911053E-09  -4.04805512612992E-09  -3.13222099590349E-18
      4.04014417776563E-07
      0.00000000000000E+00  -4.04851601610778E-12   0.00000000000000E+00   7.96923090189838E-18   1.23848428380324E-22
      4.04851666102530E-09   4.04851666899466E-09  -8.97509206713516E-19  -1.95396278280541E-01  -1.95396278280541E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.44548075237493E-14   0.00000000000000E+00  -1.44548075237493E-14
      4.02967133193564E-18  -1.95344063983078E-01  -1.94068564383294E-01   0.00000000000000E+00   5.66059427524764E-17
     -9.55729230321737E-23  -4.04850227079298E-09  -4.04850221418713E-09  -3.13216212522213E-18
      4.09014417776563E-07
      0.00000000000000E+00  -4.04888339505661E-12   0.00000000000000E+00   6.81291855954727E-18   1.23846952370238E-22
      4.04886427789157E-09   4.04886428470461E-09  -8.97497893427674E-19  -1.95402789733961E-01  -1.95402789733961E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.37219894738545E-14   0.00000000000000E+00  -1.37219894738545E-14
      4.02960272198827E-18  -1.95333246388343E-01  -1.94057637035760E-01   0.00000000000000E+00   6.13080632267403E-17
     -9.55714017855811E-23  -4.04885062402310E-09  -4.04885056271514E-09  -3.13210482856060E-18
      4.14014417776563E-07
      0.00000000000000E+00  -4.04897523979382E-12   0.00000000000000E+00   4.84549670494666E-17   1.23842385705862E-22
      4.04902432761409E-09   4.04902437606918E-09  -8.97491023062029E-19  -1.95407065732267E-01  -1.95407065732267E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08800766656007E-14   0.00000000000000E+00  -1.08800766656007E-14
      4.02954832160495E-18  -1.95322175781762E-01  -1.94046515106452E-01   0.00000000000000E+00   1.27535709823787E-17
     -9.55700226447351E-23  -4.04901350874599E-09  -4.04901349599251E-09  -3.13205729854292E-18
      4.19014417776563E-07
      0.00000000000000E+00  -4.04888339505661E-12   0.00000000000000E+00   4.26832976419818E-17   1.23834050435676E-22
      4.04889811884769E-09   4.04889816153111E-09  -8.97491339004197E-19  -1.95407618117108E-01  -1.95407618117108E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.42958605145549E-15   0.00000000000000E+00  -5.42958605145549E-15
      4.02952117367469E-18  -1.95312204815476E-01  -1.94036582184029E-01   0.00000000000000E+00   2.34304411471436E-19
     -9.55690259824338E-23  -4.04889273217927E-09  -4.04889273194506E-09  -3.13202983467049E-18
      4.24014417776563E-07
      0.00000000000000E+00  -4.04833232663336E-12   0.00000000000000E+00   4.01863129776709E-16   1.23821486817576E-22
      4.04838376518588E-09   4.04838416704914E-09  -8.97501771602517E-19  -1.95402834093685E-01  -1.95402834093685E-01
      0.00000000000000E+00   0.00000000000000E+00   2.99076853289244E-15   0.00000000000000E+00   2.99076853289244E-15
      4.02953612751735E-18  -1.95305101356834E-01  -1.94029638122509E-01   0.00000000000000E+00  -3.94801192711770E-16
     -9.55687011841243E-23  -4.04838676301638E-09  -4.04838715781767E-09  -3.13203435591484E-18
      4.29014417776563E-07
      0.00000000000000E+00  -4.04741387926129E-12   0.00000000000000E+00   1.37201422443329E-16   1.23804590828160E-22
      4.04738867576817E-09   4.04738881296972E-09  -8.97525139279103E-19  -1.95391132923784E-01  -1.95391132923784E-01
      0.00000000000000E+00   0.00000000000000E+00   1.45027798318296E-14   0.00000000000000E+00   1.45027798318296E-14
      4.02960864141651E-18  -1.95302985839368E-01  -1.94027832489307E-01   0.00000000000000E+00  -1.75019455231564E-16
     -9.55693691607615E-23  -4.04740314073000E-09  -4.04740331574955E-09  -3.13208350213741E-18
      4.34014417776563E-07
      0.00000000000000E+00  -4.04585251872876E-12   0.00000000000000E+00   4.34012111869209E-17   1.23783792270812E-22
      4.04584478756170E-09   4.04584483096304E-09  -8.97563719519580E-19  -1.95371192194814E-01  -1.95371192194814E-01
      0.00000000000000E+00   0.00000000000000E+00   2.88693478532080E-14   0.00000000000000E+00   2.88693478532080E-14
      4.02975298815578E-18  -1.95308200189664E-01  -1.94033528729415E-01   0.00000000000000E+00  -1.37304117052774E-16
     -9.55713526042528E-23  -4.04587356300668E-09  -4.04587370031090E-09  -3.13218926863620E-18
      4.39014417776563E-07
      0.00000000000000E+00  -4.04374008977299E-12   0.00000000000000E+00   2.23504160003441E-16   1.23760215373461E-22
      4.04372856077076E-09   4.04372878427504E-09  -8.97618733280625E-19  -1.95342225282120E-01  -1.95342225282120E-01
      0.00000000000000E+00   0.00000000000000E+00   4.53816763942632E-14   0.00000000000000E+00   4.53816763942632E-14
      4.02997989653775E-18  -1.95323088993590E-01  -1.94049079069343E-01   0.00000000000000E+00  -4.00991114651041E-16
     -9.55749353813263E-23  -4.04377376496022E-09  -4.04377416595143E-09  -3.13236116325713E-18
      4.44014417776563E-07
      0.00000000000000E+00  -4.04107659239397E-12   0.00000000000000E+00   6.16089335736332E-17   1.23735796219142E-22
      4.04108212214178E-09   4.04108218375083E-09  -8.97689744371227E-19  -1.95304308464144E-01  -1.95304308464144E-01
      0.00000000000000E+00   0.00000000000000E+00   6.27496230553543E-14   0.00000000000000E+00   6.27496230553543E-14
      4.03029364465303E-18  -1.95349691886348E-01  -1.94076510279035E-01   0.00000000000000E+00  -3.09809021784556E-16
     -9.55803065237183E-23  -4.04114462356477E-09  -4.04114493337389E-09  -3.13260390028180E-18
      4.49014417776563E-07
      0.00000000000000E+00  -4.03804571606612E-12   0.00000000000000E+00   1.37339590994882E-16   1.23713407684741E-22
      4.03803453893669E-09   4.03803467627641E-09  -8.97774027193785E-19  -1.95258728583156E-01  -1.95258728583156E-01
      0.00000000000000E+00   0.00000000000000E+00   7.90434650534417E-14   0.00000000000000E+00   7.90434650534417E-14
      4.03068886197829E-18  -1.95389350054578E-01  -1.94117123488958E-01   0.00000000000000E+00  -4.83456235734133E-16
     -9.55875008813154E-23  -4.03811323628513E-09  -4.03811371974146E-09  -3.13291483478451E-18
      4.54014417776563E-07
      0.00000000000000E+00  -4.03483115026386E-12   0.00000000000000E+00   1.82624071325064E-17   1.23696821987889E-22
      4.03482087437082E-09   4.03482089263336E-09  -8.97865976597835E-19  -1.95208316407201E-01  -1.95208316407201E-01
      0.00000000000000E+00   0.00000000000000E+00   9.16670196195347E-14   0.00000000000000E+00   9.16670196195347E-14
      4.03114719707639E-18  -1.95442242034461E-01  -1.94171023995359E-01   0.00000000000000E+00  -4.21027371141567E-16
     -9.55963230009681E-23  -4.03491213862551E-09  -4.03491255965298E-09  -3.13328122047856E-18
      4.56514417776563E-07
      0.00000000000000E+00  -4.03317794499412E-12   0.00000000000000E+00  -3.26303961366356E-17   1.23690513510893E-22
      4.03320937510252E-09   4.03320934247225E-09  -8.97912970276333E-19  -1.95182362355961E-01  -1.95182362355961E-01
      0.00000000000000E+00   0.00000000000000E+00   9.66960230922611E-14   0.00000000000000E+00   9.66960230922611E-14
      4.03138893713412E-18  -1.95471929883924E-01  -1.94201217982989E-01   0.00000000000000E+00  -4.00029604256472E-16
     -9.56011019054483E-23  -4.03330563846564E-09  -4.03330603849534E-09  -3.13347596685779E-18
      4.57358167776563E-07
      0.00000000000000E+00  -4.03262687657088E-12   0.00000000000000E+00  -3.25783230030616E-17   1.23688631063104E-22
      4.03266646666434E-09   4.03266643408614E-09  -8.97928909592913E-19  -1.95173536781852E-01  -1.95173536781852E-01
      0.00000000000000E+00   0.00000000000000E+00   9.82317070674950E-14   0.00000000000000E+00   9.82317070674950E-14
      4.03147182013696E-18  -1.95482315025853E-01  -1.94211773691186E-01   0.00000000000000E+00  -4.10550068476785E-16
     -9.56027545359975E-23  -4.03276425524304E-09  -4.03276466579320E-09  -3.13354291054405E-18
      4.58497230276563E-07
      0.00000000000000E+00  -4.03198396341042E-12   0.00000000000000E+00  -3.23344495383417E-17   1.23686593120553E-22
      4.03193921586917E-09   4.03193918353484E-09  -8.97950471022509E-19  -1.95161553763149E-01  -1.95161553763149E-01
      0.00000000000000E+00   0.00000000000000E+00   9.99761346669725E-14   0.00000000000000E+00   9.99761346669725E-14
      4.03158569920286E-18  -1.95496987573140E-01  -1.94226674818501E-01   0.00000000000000E+00  -4.23833653631546E-16
     -9.56050533233157E-23  -4.03203873583576E-09  -4.03203915966951E-09  -3.13363522818035E-18
      4.60034964651563E-07
      0.00000000000000E+00  -4.03097367130114E-12   0.00000000000000E+00  -3.15788166683088E-17   1.23684900576721E-22
      4.03097875010529E-09   4.03097871852659E-09  -8.97979379212258E-19  -1.95145396657755E-01  -1.95145396657755E-01
      0.00000000000000E+00   0.00000000000000E+00   1.01632818547087E-13   0.00000000000000E+00   1.01632818547087E-13
      4.03174198348156E-18  -1.95517935805407E-01  -1.94247925136111E-01   0.00000000000000E+00  -4.39881717192164E-16
     -9.56082646436219E-23  -4.03107991146333E-09  -4.03108035134514E-09  -3.13376260426930E-18
      4.62110906057813E-07
      0.00000000000000E+00  -4.02977968971744E-12   0.00000000000000E+00  -2.88843740026954E-17   1.23684915039811E-22
      4.02975179973689E-09   4.02975177085264E-09  -8.98017246974201E-19  -1.95124036538448E-01  -1.95124036538448E-01
      0.00000000000000E+00   0.00000000000000E+00   1.02340373489551E-13   0.00000000000000E+00   1.02340373489551E-13
      4.03195443610042E-18  -1.95548114119887E-01  -1.94278489795130E-01   0.00000000000000E+00  -4.57825890780006E-16
     -9.56127484734632E-23  -4.02985365340014E-09  -4.02985411122613E-09  -3.13393718912622E-18
      4.64913426956250E-07
      0.00000000000000E+00  -4.02831017392212E-12   0.00000000000000E+00  -1.39267577596402E-17   1.23690093173120E-22
      4.02831105553777E-09   4.02831104161114E-09  -8.98063929897632E-19  -1.95097252079536E-01  -1.95097252079536E-01
      0.00000000000000E+00   0.00000000000000E+00   9.98339949164977E-14   0.00000000000000E+00   9.98339949164977E-14
      4.03223422295755E-18  -1.95591645555885E-01  -1.94322475948593E-01   0.00000000000000E+00  -4.80526142616016E-16
     -9.56189168096710E-23  -4.02841039507981E-09  -4.02841087560605E-09  -3.13417029305992E-18
      4.68696830169141E-07
      0.00000000000000E+00  -4.02702434760122E-12   0.00000000000000E+00   1.04649405306704E-16   1.23708953858825E-22
      4.02701790363884E-09   4.02701800828837E-09  -8.98111908609256E-19  -1.95068538021648E-01  -1.95068538021648E-01
      0.00000000000000E+00   0.00000000000000E+00   8.84038017912278E-14   0.00000000000000E+00   8.84038017912278E-14
      4.03256869018528E-18  -1.95652983561814E-01  -1.94384224986996E-01   0.00000000000000E+00  -5.78228578947346E-16
     -9.56269367348440E-23  -4.02710583386148E-09  -4.02710641209015E-09  -3.13445678157602E-18
      4.73696830169141E-07
      0.00000000000000E+00  -4.02711619233843E-12   0.00000000000000E+00   5.11477747141523E-17   1.23759926626240E-22
      4.02714238566747E-09   4.02714243681537E-09  -8.98129822788075E-19  -1.95053967286471E-01  -1.95053967286471E-01
      0.00000000000000E+00   0.00000000000000E+00   5.54286973594146E-14   0.00000000000000E+00   5.54286973594146E-14
      4.03284583367207E-18  -1.95729739825678E-01  -1.94460952436853E-01   0.00000000000000E+00  -4.23671476719055E-16
     -9.56353825475259E-23  -4.02719744184116E-09  -4.02719786551273E-09  -3.13471601088400E-18
      4.78696830169141E-07
      0.00000000000000E+00  -4.02987153445465E-12   0.00000000000000E+00   2.70614851327896E-17   1.23841010629072E-22
      4.02984194013864E-09   4.02984196720025E-09  -8.98081094826502E-19  -1.95074346321170E-01  -1.95074346321170E-01
      0.00000000000000E+00   0.00000000000000E+00   1.54994111302336E-15   0.00000000000000E+00   1.54994111302336E-15
      4.03285358337764E-18  -1.95790324846012E-01  -1.94520703927120E-01   0.00000000000000E+00  -2.06579619355732E-16
     -9.56396751462571E-23  -4.02984331056165E-09  -4.02984351714137E-09  -3.13477248855114E-18
      4.81196830169141E-07
      0.00000000000000E+00  -4.03189211867322E-12   0.00000000000000E+00   4.19616907140745E-17   1.23889470273069E-22
      4.03192952757629E-09   4.03192956953810E-09  -8.98037367672896E-19  -1.95094764190445E-01  -1.95094764190445E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.09170371772617E-14   0.00000000000000E+00  -3.09170371772617E-14
      4.03277629078470E-18  -1.95814900716361E-01  -1.94544632319401E-01   0.00000000000000E+00  -1.00577972723859E-16
     -9.56405117047854E-23  -4.03189855192286E-09  -4.03189865250093E-09  -3.13473892311180E-18
      4.84571830169141E-07
      0.00000000000000E+00  -4.03630066605918E-12   0.00000000000000E+00   6.54184390992995E-17   1.23969772862737E-22
      4.03631495926924E-09   4.03631502468781E-09  -8.97936437625250E-19  -1.95144658278239E-01  -1.95144658278239E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.52658557574837E-14   0.00000000000000E+00  -8.52658557574837E-14
      4.03248851852151E-18  -1.95832956629528E-01  -1.94561323691806E-01   0.00000000000000E+00   8.78172440402714E-17
     -9.56385283432539E-23  -4.03622984664920E-09  -4.03622975883205E-09  -3.13455208089626E-18
      4.89128080169141E-07
      0.00000000000000E+00  -4.04557698451714E-12   0.00000000000000E+00   2.83882383205931E-16   1.24103906702840E-22
      4.04554430368843E-09   4.04554458757094E-09  -8.97709593954572E-19  -1.95260864928781E-01  -1.95260864928781E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.77238616333155E-13   0.00000000000000E+00  -1.77238616333155E-13
      4.03168097507585E-18  -1.95816747193751E-01  -1.94542235445813E-01   0.00000000000000E+00   2.44572938782856E-16
     -9.56283222647999E-23  -4.04536759352745E-09  -4.04536734895461E-09  -3.13397138112127E-18
      4.94128080169141E-07
      0.00000000000000E+00  -4.05999660825872E-12   0.00000000000000E+00   4.66593249030747E-16   1.24275270799529E-22
      4.05998530613111E-09   4.05998577272448E-09  -8.97339435272095E-19  -1.95454671439934E-01  -1.95454671439933E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.96573144468964E-13   0.00000000000000E+00  -2.96573144468964E-13
      4.03019810935350E-18  -1.95732123197964E-01  -1.94453099268600E-01   0.00000000000000E+00   5.74260879309267E-16
     -9.56057847823490E-23  -4.05968977384080E-09  -4.05968919958002E-09  -3.13285867408141E-18
      4.99128080169141E-07
      0.00000000000000E+00  -4.07864108991185E-12   0.00000000000000E+00   5.08537975238551E-16   1.24457884368236E-22
      4.07864013475924E-09   4.07864064329734E-09  -8.96846897344959E-19  -1.95716567751380E-01  -1.95716567751380E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.26292012946822E-13   0.00000000000000E+00  -4.26292012946822E-13
      4.02806664928877E-18  -1.95563990131177E-01  -1.94279129672213E-01   0.00000000000000E+00   1.11995103137938E-15
     -9.55701889836461E-23  -4.07821547123533E-09  -4.07821435128439E-09  -3.13121975194381E-18
      5.04128080169141E-07
      0.00000000000000E+00  -4.10077567157886E-12   0.00000000000000E+00   2.24054600714259E-16   1.24632041365888E-22
      4.10081192257474E-09   4.10081214662946E-09  -8.96246337315485E-19  -1.96040206688399E-01  -1.96040206688398E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.53738400682201E-13   0.00000000000000E+00  -5.53738400682201E-13
      4.02529795728536E-18  -1.95299704112224E-01  -1.94007898338662E-01   0.00000000000000E+00   2.02686648907287E-15
     -9.55208154945870E-23  -4.10026043509518E-09  -4.10025840822878E-09  -3.12905161996987E-18
      5.09128080169141E-07
      0.00000000000000E+00  -4.12502268220165E-12   0.00000000000000E+00   2.44980483795983E-16   1.24771180855857E-22
      4.12504154493898E-09   4.12504178991959E-09  -8.95571998770621E-19  -1.96408614044651E-01  -1.96408614044650E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.61342894913347E-13   0.00000000000000E+00  -6.61342894913347E-13
      4.02199124281079E-18  -1.94934037065566E-01  -1.93634631364994E-01   0.00000000000000E+00   2.57925084244976E-15
     -9.54584427113392E-23  -4.12438302627542E-09  -4.12438044702467E-09  -3.12641924404017E-18
      5.14128080169141E-07
      0.00000000000000E+00  -4.14899415861281E-12   0.00000000000000E+00   3.12197874729794E-16   1.24842783975104E-22
      4.14897445936747E-09   4.14897477156547E-09  -8.94881600668596E-19  -1.96792072985896E-01  -1.96792072985895E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.26821918830204E-13   0.00000000000000E+00  -7.26821918830204E-13
      4.01835713321664E-18  -1.94473032095289E-01  -1.93166106654657E-01   0.00000000000000E+00   2.93689637892363E-15
     -9.53858788700718E-23  -4.14825088654292E-09  -4.14824794964664E-09  -3.12347553254804E-18
      5.19128080169141E-07
      0.00000000000000E+00  -4.16929184553568E-12   0.00000000000000E+00   4.88442452250470E-16   1.24810299953734E-22
      4.16929071598609E-09   4.16929120442867E-09  -8.94258457869447E-19  -1.97146744658752E-01  -1.97146744658751E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.24064264589786E-13   0.00000000000000E+00  -7.24064264589786E-13
      4.01473681189369E-18  -1.93938010350637E-01  -1.92624683114409E-01   0.00000000000000E+00   2.88005596487620E-15
     -9.53084281801061E-23  -4.16857002021994E-09  -4.16856714016407E-09  -3.12047835402425E-18
      5.24128080169141E-07
      0.00000000000000E+00  -4.18178272979590E-12   0.00000000000000E+00   1.38393220066721E-15   1.24636406038222E-22
      4.18175078814139E-09   4.18175217207371E-09  -8.93811398981892E-19  -1.97414437789678E-01  -1.97414437789677E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.24811881121299E-13   0.00000000000000E+00  -6.24811881121299E-13
      4.01161275248808E-18  -1.93369179375050E-01  -1.92051895091633E-01   0.00000000000000E+00   1.87746842789689E-15
     -9.52342927884352E-23  -4.18112923766092E-09  -4.18112736019259E-09  -3.11780135350619E-18
      5.29128080169141E-07
      0.00000000000000E+00  -4.18132350610986E-12   0.00000000000000E+00   1.42657710733523E-14   1.24286656908300E-22
      4.18138430359680E-09   4.18139856936800E-09  -8.93671586262660E-19  -1.97524076364865E-01  -1.97524076364865E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.01635929115759E-13   0.00000000000000E+00  -4.01635929115759E-13
      4.00960457284251E-18  -1.92828190042960E-01  -1.91510950793110E-01   0.00000000000000E+00  -1.17910646454659E-14
     -9.51745738356723E-23  -4.18098514237415E-09  -4.18099693343889E-09  -3.11593298657984E-18
      5.34128080169141E-07
      0.00000000000000E+00  -4.16286271393115E-12   0.00000000000000E+00   8.80075294351550E-15   1.23734101571130E-22
      4.16291232627435E-09   4.16292112702742E-09  -8.93986029956288E-19  -1.97395039441189E-01  -1.97395039441189E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.15848487914868E-14   0.00000000000000E+00  -3.15848487914868E-14
      4.00944664859855E-18  -1.92398595645550E-01  -1.91087059475640E-01   0.00000000000000E+00  -7.57709728315409E-15
     -9.51431226154143E-23  -4.16288196508125E-09  -4.16288954217862E-09  -3.11546061864226E-18
      5.39128080169140E-07
      0.00000000000000E+00  -4.12134889271335E-12   0.00000000000000E+00   7.87644468685240E-14   1.22965174084986E-22
      4.12136311559803E-09   4.12144188004502E-09  -8.94904784636504E-19  -1.96943878158034E-01  -1.96943878158034E-01
      0.00000000000000E+00   0.00000000000000E+00   4.97954404688363E-13   0.00000000000000E+00   4.97954404688363E-13
      4.01193642062199E-18  -1.92183401285764E-01  -1.90884788662462E-01   0.00000000000000E+00  -8.01654712875053E-14
     -9.51559267415850E-23  -4.12185966897833E-09  -4.12193983444971E-09  -3.11703163598549E-18
      5.44128080169140E-07
      0.00000000000000E+00  -4.05301640823095E-12   0.00000000000000E+00   2.39927769771025E-14   1.21984471454370E-22
      4.05305077735394E-09   4.05307477013104E-09  -8.96565655397674E-19  -1.96092859246794E-01  -1.96092859246795E-01
      0.00000000000000E+00   0.00000000000000E+00   1.18380799339389E-12   0.00000000000000E+00   1.18380799339389E-12
      4.01785546058896E-18  -1.92298128231419E-01  -1.91020821959927E-01   0.00000000000000E+00  -2.77363738861850E-14
     -9.52300333374564E-23  -4.05423084175045E-09  -4.05425857812443E-09  -3.12128980519128E-18
      5.49128080169140E-07
      0.00000000000000E+00  -3.95639574468863E-12   0.00000000000000E+00   1.89074932118906E-13   1.20819487538996E-22
      3.95633654196375E-09   3.95652561689599E-09  -8.99066872794083E-19  -1.94784568423378E-01  -1.94784568423380E-01
      0.00000000000000E+00   0.00000000000000E+00   1.99777859703425E-12   0.00000000000000E+00   1.99777859703425E-12
      4.02784435357413E-18  -1.92860650604409E-01  -1.91613558616917E-01   0.00000000000000E+00  -1.98292153253593E-13
     -9.53804829876426E-23  -3.95832510333967E-09  -3.95852339549302E-09  -3.12877748078005E-18
      5.54128080169140E-07
      0.00000000000000E+00  -3.83332379683054E-12   0.00000000000000E+00   3.35519297366463E-14   1.19535338862315E-22
      3.83327949167561E-09   3.83331304360546E-09  -9.02440601134824E-19  -1.92996756165548E-01  -1.92996756165551E-01
      0.00000000000000E+00   0.00000000000000E+00   2.88384004207484E-12   0.00000000000000E+00   2.88384004207484E-12
      4.04226355378450E-18  -1.93973716809725E-01  -1.92765116095164E-01   0.00000000000000E+00  -4.51185610715648E-14
     -9.56210698548135E-23  -3.83615176508637E-09  -3.83619688364754E-09  -3.13982295264968E-18
      5.59128080169140E-07
      0.00000000000000E+00  -3.68967862783797E-12   0.00000000000000E+00  -1.45449427815908E-15   1.18232658848818E-22
      3.68964233583567E-09   3.68964088134151E-09  -9.06611308482280E-19  -1.90764484486910E-01  -1.90764484486914E-01
      0.00000000000000E+00   0.00000000000000E+00   3.74776194861744E-12   0.00000000000000E+00   3.74776194861744E-12
      4.06100236352759E-18  -1.95708337610888E-01  -1.94544719139951E-01   0.00000000000000E+00  -1.39036934759450E-14
     -9.59554388484420E-23  -3.69337473959655E-09  -3.69338864329013E-09  -3.15439105504531E-18
      5.64128080169140E-07
      0.00000000000000E+00  -3.53611422722699E-12   0.00000000000000E+00   1.59600692906923E-14   1.17069377321407E-22
      3.53609435795902E-09   3.53611031802843E-09  -9.11357885564436E-19  -1.88200351136768E-01  -1.88200351136772E-01
      0.00000000000000E+00   0.00000000000000E+00   4.46150517105352E-12   0.00000000000000E+00   4.46150517105352E-12
      4.08330988938286E-18  -1.98082255223394E-01  -1.96966788860918E-01   0.00000000000000E+00  -3.61628255986710E-14
     -9.63774197559677E-23  -3.54053566037379E-09  -3.54057182319948E-09  -3.17195200381843E-18
      5.69128080169140E-07
      0.00000000000000E+00  -3.38796866611125E-12   0.00000000000000E+00  -1.50578969400567E-15   1.16273203766513E-22
      3.38797372245189E-09   3.38797221666231E-09  -9.16275373035563E-19  -1.85513851136893E-01  -1.85513851136897E-01
      0.00000000000000E+00   0.00000000000000E+00   4.86829094120486E-12   0.00000000000000E+00   4.86829094120486E-12
      4.10765134408888E-18  -2.01040570921952E-01  -1.99971643507092E-01   0.00000000000000E+00  -2.14617555534156E-14
     -9.68674696337416E-23  -3.39281904584787E-09  -3.39284050760352E-09  -3.19137597105332E-18
      5.74128080169140E-07
      0.00000000000000E+00  -3.26452933930433E-12   0.00000000000000E+00   3.98881285267230E-15   1.16137831399784E-22
      3.26454271076976E-09   3.26454669958273E-09  -9.20751461141477E-19  -1.83022985637844E-01  -1.83022985637849E-01
      0.00000000000000E+00   0.00000000000000E+00   4.79405620135363E-12   0.00000000000000E+00   4.79405620135363E-12
      4.13162162509565E-18  -2.04440780869466E-01  -2.03410765321180E-01   0.00000000000000E+00  -2.90901784286079E-14
     -9.73865816381560E-23  -3.26931166560556E-09  -3.26934075578408E-09  -3.21087016395417E-18
      5.79128080169140E-07
      0.00000000000000E+00  -3.18848189689650E-12   0.00000000000000E+00  -7.79910080263742E-16   1.17009635356436E-22
      3.18845852688384E-09   3.18845774697388E-09  -9.23974745943286E-19  -1.81149705287635E-01  -1.81149705287639E-01
      0.00000000000000E+00   0.00000000000000E+00   4.07097000278397E-12   0.00000000000000E+00   4.07097000278397E-12
      4.15197647510957E-18  -2.08040966853224E-01  -2.07035150622469E-01   0.00000000000000E+00  -2.29207326401754E-14
     -9.78787146345186E-23  -3.19250579624393E-09  -3.19252871697667E-09  -3.22800172916629E-18
      5.84128080169140E-07
      0.00000000000000E+00  -3.18517548635703E-12   0.00000000000000E+00  -4.08516339013252E-17   1.19228593154333E-22
      3.18516821042413E-09   3.18516816957261E-09  -9.24993449641722E-19  -1.80392141004787E-01  -1.80392141004790E-01
      0.00000000000000E+00   0.00000000000000E+00   2.56049538984049E-12   0.00000000000000E+00   2.56049538984049E-12
      4.16477895205878E-18  -2.11491299587334E-01  -2.10486996495819E-01   0.00000000000000E+00  -1.89566932168577E-14
     -9.82708809530754E-23  -3.18770970826914E-09  -3.18772866496245E-09  -3.23978550241705E-18
      5.89128080169140E-07
      0.00000000000000E+00  -3.28289828674584E-12   0.00000000000000E+00   9.84143415221881E-16   1.23025360169277E-22
      3.28292664396049E-09   3.28292762810403E-09  -9.22845752938240E-19  -1.81264597908562E-01  -1.81264597908562E-01
      0.00000000000000E+00   0.00000000000000E+00   1.83543670102359E-13   0.00000000000000E+00   1.83543670102359E-13
      4.16569667040929E-18  -2.14325741417997E-01  -2.13291388269262E-01   0.00000000000000E+00  -1.07883623040800E-14
     -9.84787024027990E-23  -3.28310038341172E-09  -3.28311117177413E-09  -3.24285091747104E-18
      5.94128080169140E-07
      0.00000000000000E+00  -3.51287750871348E-12   0.00000000000000E+00   2.32751236945006E-15   1.28383042323542E-22
      3.51292486268491E-09   3.51292719019741E-09  -9.16752656710627E-19  -1.84209005093393E-01  -1.84209005093390E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.05318977263090E-12   0.00000000000000E+00  -3.05318977263090E-12
      4.15043072154613E-18  -2.15953345153043E-01  -2.14847549583252E-01   0.00000000000000E+00   1.77869661545962E-15
     -9.84131750243775E-23  -3.50987577912130E-09  -3.50987400042478E-09  -3.23367806483550E-18
      5.99128080169140E-07
      0.00000000000000E+00  -3.90817725765468E-12   0.00000000000000E+00   4.02757317727877E-15   1.34904903540107E-22
      3.90813807715000E-09   3.90814210472331E-09  -9.06330728116211E-19  -1.89493082363737E-01  -1.89493082363730E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.03551812562012E-12   0.00000000000000E+00  -7.03551812562012E-12
      4.11525313091803E-18  -2.15655183369935E-01  -2.14426127706306E-01   0.00000000000000E+00   1.81500108861429E-14
     -9.79883266913348E-23  -3.90112473660848E-09  -3.90110658659770E-09  -3.20892240280182E-18
      6.04128080169140E-07
      0.00000000000000E+00  -4.49846338368745E-12   0.00000000000000E+00   5.95274733853658E-15   1.41749555988951E-22
      4.49846394007203E-09   4.49846989281952E-09  -8.91740441645302E-19  -1.97127646384447E-01  -1.97127646384435E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15349207818380E-11   0.00000000000000E+00  -1.15349207818380E-11
      4.05757852700884E-18  -2.12604141540047E-01  -2.11190516123129E-01   0.00000000000000E+00   3.69821758370184E-14
     -9.71287034894759E-23  -4.48697195421341E-09  -4.48693497203767E-09  -3.16583808536354E-18
      6.09128080169140E-07
      0.00000000000000E+00  -5.30017609477195E-12   0.00000000000000E+00   8.86965333289588E-15   1.47675641890827E-22
      5.30019433189208E-09   5.30020320154556E-09  -8.73687090524973E-19  -2.06840461839327E-01  -2.06840461839310E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.62296329413764E-11   0.00000000000000E+00  -1.62296329413764E-11
      3.97643036230196E-18  -2.05933307116189E-01  -2.04268567201253E-01   0.00000000000000E+00   5.52495168381213E-14
     -9.57781133625074E-23  -5.28402881812092E-09  -5.28397356860418E-09  -3.10274327177699E-18
      6.14128080169140E-07
      0.00000000000000E+00  -6.30100819612237E-12   0.00000000000000E+00   1.03087992634241E-14   1.51176052503973E-22
      6.30102911417029E-09   6.30103942296970E-09  -8.53258062684234E-19  -2.18126029326842E-01  -2.18126029326822E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.07605092306624E-11   0.00000000000000E+00  -2.07605092306624E-11
      3.87262781614865E-18  -1.94871865635851E-01  -1.92893227543302E-01   0.00000000000000E+00   7.25225998355031E-14
     -9.39193872683313E-23  -6.28035143633879E-09  -6.28027891373905E-09  -3.01936975346441E-18
      6.19128080169140E-07
      0.00000000000000E+00  -7.44695498226068E-12   0.00000000000000E+00   1.14832588642182E-14   1.50665642136156E-22
      7.44693674170050E-09   7.44694822495951E-09  -8.31675820313317E-19  -2.30351931619521E-01  -2.30351931619496E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.47912323566157E-11   0.00000000000000E+00  -2.47912323566157E-11
      3.74867165436557E-18  -1.78936858795315E-01  -1.76598455082665E-01   0.00000000000000E+00   8.47086149264962E-14
     -9.16159915029556E-23  -7.42224170121773E-09  -7.42215699260289E-09  -2.91699583405225E-18
      6.24128080169140E-07
      0.00000000000000E+00  -8.63965073963763E-12   0.00000000000000E+00   1.19556235951983E-14   1.44810953215728E-22
      8.63965650351253E-09   8.63966845913628E-09  -8.10096580572814E-19  -2.42864309682761E-01  -2.42864309682734E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.79952941706957E-11   0.00000000000000E+00  -2.79952941706957E-11
      3.60869518351209E-18  -1.58128353182842E-01  -1.55415171152734E-01   0.00000000000000E+00   9.04731143218002E-14
     -8.90743321139215E-23  -8.61176363807980E-09  -8.61167316496557E-09  -2.79859860293928E-18
      6.29128080169140E-07
      0.00000000000000E+00  -9.74298156771165E-12   0.00000000000000E+00   1.12532188954517E-14   1.32986995533730E-22
      9.74297164770078E-09   9.74298290091981E-09  -7.89569596340468E-19  -2.55029976928048E-01  -2.55029976928019E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.99933122503583E-11   0.00000000000000E+00  -2.99933122503583E-11
      3.45872862226030E-18  -1.33087510819876E-01  -1.30027335203075E-01   0.00000000000000E+00   9.03747549520634E-14
     -8.65278566926747E-23  -9.71307996342431E-09  -9.71298958866945E-09  -2.66915902591983E-18
      6.34128080169140E-07
      0.00000000000000E+00  -1.05678391525724E-11   0.00000000000000E+00   8.60541338036138E-15   1.15072468865571E-22
      1.05678377772431E-08   1.05678463826566E-08  -7.71223588570515E-19  -2.66185582096582E-01  -2.66185582096552E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.04025122538429E-11   0.00000000000000E+00  -3.04025122538429E-11
      3.30671606099109E-18  -1.05320226650886E-01  -1.02000283635340E-01   0.00000000000000E+00   8.57831796521017E-14
     -8.33374740273787E-23  -1.05375296535823E-08  -1.05374438704027E-08  -2.53549247242057E-18
      6.39128080169140E-07
      0.00000000000000E+00  -1.08079212956329E-11   0.00000000000000E+00   3.23442987400377E-14   9.10310555688256E-23
      1.08079339660662E-08   1.08079663103650E-08  -7.56554834259046E-19  -2.75514409365485E-01  -2.75514409365456E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.86241033785017E-11   0.00000000000000E+00  -2.86241033785017E-11
      3.16359554409858E-18  -7.77145127848384E-02  -7.43183533175998E-02   0.00000000000000E+00   4.59395325317507E-14
     -7.65192878838597E-23  -1.07793881465190E-08  -1.07793422069865E-08  -2.40704070983953E-18
      6.44128080169139E-07
      0.00000000000000E+00  -1.01008086638722E-11   0.00000000000000E+00  -6.45969720573475E-15   6.48131203588840E-23
      1.01008051804526E-08   1.01007987207554E-08  -7.47395132389925E-19  -2.81924392896617E-01  -2.81924392896594E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.30630812710052E-11   0.00000000000000E+00  -2.30630812710052E-11
      3.04828013774355E-18  -5.47368501527601E-02  -5.15617225127421E-02   0.00000000000000E+00   6.24796120019146E-14
     -6.38232793387881E-23  -1.00777981190964E-08  -1.00777356394844E-08  -2.30088500535362E-18
      6.49128080169139E-07
      0.00000000000000E+00  -8.61815907113107E-12   0.00000000000000E+00  -1.46112787332829E-14   4.47761922242813E-23
      8.61814094945125E-09   8.61812633817256E-09  -7.45876899677381E-19  -2.84043806471916E-01  -2.84043806471903E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.27895902335524E-11   0.00000000000000E+00  -1.27895902335524E-11
      2.98433218657579E-18  -3.98250972878831E-02  -3.71138647403936E-02   0.00000000000000E+00   4.40989805493058E-14
     -5.14992448806768E-23  -8.60538084691950E-09  -8.60533674793900E-09  -2.23845528689841E-18
      6.54128080169139E-07
      0.00000000000000E+00  -7.06699330443315E-12   0.00000000000000E+00  -1.36600845983593E-14   3.37309232814443E-23
      7.06700128204198E-09   7.06698762195741E-09  -7.54724765711566E-19  -2.80417568633068E-01  -2.80417568633068E-01
      0.00000000000000E+00   0.00000000000000E+00   2.85587116399466E-13   0.00000000000000E+00   2.85587116399466E-13
      2.98576012215778E-18  -3.29093930967600E-02  -3.06827490424514E-02   0.00000000000000E+00   1.87890834230621E-14
     -4.64108054298354E-23  -7.06729199815719E-09  -7.06727320907382E-09  -2.23103535644622E-18
      6.59128080169139E-07
      0.00000000000000E+00  -5.76105298607932E-12   0.00000000000000E+00  -1.30342818940242E-14   2.94568975294066E-23
      5.76111039857666E-09   5.76109736429479E-09  -7.76366068676060E-19  -2.69807416306548E-01  -2.69807416306563E-01
      0.00000000000000E+00   0.00000000000000E+00   1.44810482505488E-11   0.00000000000000E+00   1.44810482505488E-11
      3.05816536341053E-18  -3.24427776232863E-02  -3.06231013453204E-02   0.00000000000000E+00  -4.34487988216410E-15
     -4.94806612565682E-23  -5.77557406766541E-09  -5.77557841254534E-09  -2.28179929473447E-18
      6.64128080169139E-07
      0.00000000000000E+00  -4.53428283119839E-12   0.00000000000000E+00  -1.23762219838859E-14   2.91679551082668E-23
      4.53424315454650E-09   4.53423077832455E-09  -8.11991537947983E-19  -2.51375426622877E-01  -2.51375426622907E-01
      0.00000000000000E+00   0.00000000000000E+00   2.95800571204986E-11   0.00000000000000E+00   2.95800571204986E-11
      3.20606564901302E-18  -3.77407473793241E-02  -3.63028583017215E-02   0.00000000000000E+00  -2.96060731453866E-14
     -5.94358623051171E-23  -4.56378122937184E-09  -4.56381083544504E-09  -2.39407411106504E-18
      6.69128080169139E-07
      0.00000000000000E+00  -3.19656423377076E-12   0.00000000000000E+00  -1.36100191169900E-14   2.93877887745638E-23
      3.19655181088412E-09   3.19653820086503E-09  -8.61834587313041E-19  -2.24810460157227E-01  -2.24810460157272E-01
      0.00000000000000E+00   0.00000000000000E+00   4.48664721730245E-11   0.00000000000000E+00   4.48664721730245E-11
      3.43039800987814E-18  -4.90540509845146E-02  -4.80328070855843E-02   0.00000000000000E+00  -5.92446582106094E-14
     -7.28805059977331E-23  -3.24134542837977E-09  -3.24140467303806E-09  -2.56856342256510E-18
      6.74128080169139E-07
      0.00000000000000E+00  -1.87482662061724E-12   0.00000000000000E+00  -1.36186985422755E-14   2.48115409887076E-23
      1.87483510880743E-09   1.87482149010891E-09  -9.25983829617584E-19  -1.90570130217197E-01  -1.90570130217255E-01
      0.00000000000000E+00   0.00000000000000E+00   5.75513763395381E-11   0.00000000000000E+00   5.75513763395381E-11
      3.71815489157583E-18  -6.60318365292444E-02  -6.54230221852800E-02   0.00000000000000E+00  -9.88037485560505E-14
     -8.38130600120178E-23  -1.93227406269981E-09  -1.93237286644845E-09  -2.79217106195825E-18
      6.79128080169139E-07
      0.00000000000000E+00  -8.89057056168859E-13   0.00000000000000E+00  -1.04990414334279E-14   1.19282787647207E-23
      8.89015423241193E-10   8.89004924199771E-10  -1.00459293148112E-18  -1.49988853124133E-01  -1.49988853124197E-01
      0.00000000000000E+00   0.00000000000000E+00   6.45429089528417E-11   0.00000000000000E+00   6.45429089528417E-11
      4.04086943634004E-18  -8.68363000265429E-02  -8.65358769096461E-02   0.00000000000000E+00  -1.51899738009928E-13
     -9.01874306032562E-23  -9.53395933414512E-10  -9.53547833152612E-10  -3.03627650485892E-18
      6.84128080169139E-07
      0.00000000000000E+00  -3.42213490835245E-13   0.00000000000000E+00  -6.38376899581728E-15  -6.64001160005797E-24
      3.42193121319884E-10   3.42186737550882E-10  -1.09629264730932E-18  -1.05333104085033E-01  -1.05333104085098E-01
      0.00000000000000E+00   0.00000000000000E+00   6.46326443404586E-11   0.00000000000000E+00   6.46326443404586E-11
      4.36403265804234E-18  -1.09233527078740E-01  -1.09105356367662E-01   0.00000000000000E+00  -2.20076575118890E-13
     -9.52689922645216E-23  -4.06599305316126E-10  -4.06819381891340E-10  -3.26774001073302E-18
      6.89128080169139E-07
      0.00000000000000E+00  -1.17744953100049E-13   0.00000000000000E+00  -3.30518277966477E-15  -2.13109189939635E-23
      1.17786741224536E-10   1.17783436041735E-10  -1.18947058905871E-18  -6.22869810870113E-02  -6.22869810870683E-02
      0.00000000000000E+00   0.00000000000000E+00   5.69564719419503E-11   0.00000000000000E+00   5.69564719419503E-11
      4.64881501775209E-18  -1.31653033628143E-01  -1.31597981280863E-01   0.00000000000000E+00  -2.81417262011761E-13
     -1.00814655022679E-22  -1.74458490721573E-10  -1.74739907983686E-10  -3.45934442869338E-18
      6.94128080169139E-07
      0.00000000000000E+00  -5.62089791710064E-14   0.00000000000000E+00  -1.18705191717387E-15  -2.45475737982589E-23
      5.62010274486240E-11   5.61998403966823E-11  -1.25684693819807E-18  -3.21759997065051E-02  -3.21759997065457E-02
      0.00000000000000E+00   0.00000000000000E+00   4.06248991790960E-11   0.00000000000000E+00   4.06248991790960E-11
      4.85193951364757E-18  -1.53361025174685E-01  -1.53330520520911E-01   0.00000000000000E+00  -2.69067262942919E-13
     -1.05474653154394E-22  -9.65556723127303E-11  -9.68247395757787E-11  -3.59509257544950E-18
      6.99128080169139E-07
      0.00000000000000E+00  -4.66571265014236E-14   0.00000000000000E+00  -4.68104334492357E-16  -1.67964825660034E-23
      4.66886249823829E-11   4.66881568780316E-11  -1.29100038660438E-18  -1.73873395422766E-02  -1.73873395423009E-02
      0.00000000000000E+00   0.00000000000000E+00   2.43945155249681E-11   0.00000000000000E+00   2.43945155249681E-11
      4.97391209127241E-18  -1.74143748743422E-01  -1.74121354262966E-01   0.00000000000000E+00  -2.05778191712666E-13
     -1.08650482106247E-22  -7.08768942111783E-11  -7.10826724029996E-11  -3.68291170466803E-18
      7.04128080169139E-07
      0.00000000000000E+00  -4.80347975595365E-14   0.00000000000000E+00  -1.42848052821641E-16   1.64506070159172E-25
      4.80736333049246E-11   4.80734904568720E-11  -1.30523759913534E-18  -1.12133261117745E-02  -1.12133261117893E-02
      0.00000000000000E+00   0.00000000000000E+00   1.48444036532013E-11   0.00000000000000E+00   1.48444036532013E-11
      5.04813410953842E-18  -1.93963149457370E-01  -1.93943327429297E-01   0.00000000000000E+00  -1.61940633920118E-13
     -1.10977588234967E-22  -6.27559534760420E-11  -6.29178941100731E-11  -3.74289651040308E-18
      7.09128080169139E-07
      0.00000000000000E+00  -5.08819844129698E-14   0.00000000000000E+00  -1.91672855382119E-16   2.16425807799908E-23
      5.08734767195792E-11   5.08732850467454E-11  -1.31076381305239E-18  -8.50847131299771E-03  -8.50847131300804E-03
      0.00000000000000E+00   0.00000000000000E+00   1.03321292843140E-11   0.00000000000000E+00   1.03321292843140E-11
      5.09979475595998E-18  -2.12836540191907E-01  -2.12817257762114E-01   0.00000000000000E+00  -1.42306188635494E-13
     -1.12926783841631E-22  -6.10631081423111E-11  -6.12054143310595E-11  -3.78903094290759E-18
      7.14128080169139E-07
      0.00000000000000E+00  -5.36373265291956E-14   0.00000000000000E+00   1.88763718986123E-17   4.16709382766629E-23
      5.36004252027207E-11   5.36004440791342E-11  -1.31285618400333E-18  -7.08218947043488E-03  -7.08218947044311E-03
      0.00000000000000E+00   0.00000000000000E+00   8.23268897508596E-12   0.00000000000000E+00   8.23268897508596E-12
      5.14095820083541E-18  -2.30799538262902E-01  -2.30780058255696E-01   0.00000000000000E+00  -1.33575959949158E-13
     -1.14683795581855E-22  -6.16995570941565E-11  -6.18331330542203E-11  -3.82810201683208E-18
      7.19128080169139E-07
      0.00000000000000E+00  -5.62089791710064E-14   0.00000000000000E+00   2.56782071016059E-17   5.73284060100488E-23
      5.62376212690758E-11   5.62376469473402E-11  -1.31352877573347E-18  -6.18741539781367E-03  -6.18741539782080E-03
      0.00000000000000E+00   0.00000000000000E+00   7.13007797285497E-12   0.00000000000000E+00   7.13007797285497E-12
      5.17660859069969E-18  -2.47890652282788E-01  -2.47870688933969E-01   0.00000000000000E+00  -1.27723631161847E-13
     -1.16311616880377E-22  -6.32400012889169E-11  -6.33677249201951E-11  -3.86307981496622E-18
      7.24128080169139E-07
      0.00000000000000E+00  -5.88724765500246E-14   0.00000000000000E+00   3.02174139756701E-17   6.83610714136671E-23
      5.88988322630236E-11   5.88988624805060E-11  -1.31350533332616E-18  -5.57902460318017E-03  -5.57902460318661E-03
      0.00000000000000E+00   0.00000000000000E+00   6.43555662235386E-12   0.00000000000000E+00   6.43555662235386E-12
      5.20878637381146E-18  -2.64145366886174E-01  -2.64124784068773E-01   0.00000000000000E+00  -1.22602436475937E-13
     -1.17837463286002E-22  -6.52118166662660E-11  -6.53344191028598E-11  -3.89528104048530E-18
      7.29128080169139E-07
      0.00000000000000E+00  -6.16278186662505E-14   0.00000000000000E+00   3.47435551159939E-17   7.58702572246486E-23
      6.16481897979271E-11   6.16482245415581E-11  -1.31305562378794E-18  -5.16726696040197E-03  -5.16726696040789E-03
      0.00000000000000E+00   0.00000000000000E+00   5.92007768782168E-12   0.00000000000000E+00   5.92007768782168E-12
      5.23838676225057E-18  -2.79601510757091E-01  -2.79580224299987E-01   0.00000000000000E+00  -1.17758187928787E-13
     -1.19277261841255E-22  -6.74505440413317E-11  -6.75683022293798E-11  -3.92533113846262E-18
      7.34128080169139E-07
      0.00000000000000E+00  -6.45668502568913E-14   0.00000000000000E+00   3.94111961551237E-17   8.11150285465402E-23
      6.45236643858584E-11   6.45237037971357E-11  -1.31228274638352E-18  -4.91585225999298E-03  -4.91585225999847E-03
      0.00000000000000E+00   0.00000000000000E+00   5.48951695013561E-12   0.00000000000000E+00   5.48951695013561E-12
      5.26583434700125E-18  -2.94302486184332E-01  -2.94280429607112E-01   0.00000000000000E+00  -1.13178018679056E-13
     -1.20641751939954E-22  -6.99000427284714E-11  -7.00132207472711E-11  -3.95355160061772E-18
      7.39128080169139E-07
      0.00000000000000E+00  -6.75977265847397E-14   0.00000000000000E+00   4.51202932289706E-17   8.50477338883066E-23
      6.75756203508933E-11   6.75756654712715E-11  -1.31120740370345E-18  -4.81704902615601E-03  -4.81704902616111E-03
      0.00000000000000E+00   0.00000000000000E+00   5.10015066665489E-12   0.00000000000000E+00   5.10015066665489E-12
      5.29133510033452E-18  -3.08305148089130E-01  -3.08282252819563E-01   0.00000000000000E+00  -1.08925142214441E-13
     -1.21939247317450E-22  -7.25668909955899E-11  -7.26758161379262E-11  -3.98012769663107E-18
      7.44128080169139E-07
      0.00000000000000E+00  -7.09041371242107E-14   0.00000000000000E+00   5.28122790130116E-17   8.83022341958527E-23
      7.09084045464189E-11   7.09084573587862E-11  -1.30977414622641E-18  -4.89352785756254E-03  -4.89352785756726E-03
      0.00000000000000E+00   0.00000000000000E+00   4.72047284365574E-12   0.00000000000000E+00   4.72047284365574E-12
      5.31493746455280E-18  -3.21680656268545E-01  -3.21656830787509E-01   0.00000000000000E+00  -1.04955987493618E-13
     -1.23175631240971E-22  -7.55239742148253E-11  -7.56289302024421E-11  -4.00516331832639E-18
      7.49128080169138E-07
      0.00000000000000E+00  -7.47616160869268E-14   0.00000000000000E+00   6.54542975878194E-17   9.13216637389361E-23
      7.47432177151173E-11   7.47432831695062E-11  -1.30780611662444E-18  -5.22175774478113E-03  -5.22175774478541E-03
      0.00000000000000E+00   0.00000000000000E+00   4.28337389447160E-12   0.00000000000000E+00   4.28337389447160E-12
      5.33635433402516E-18  -3.34447844033484E-01  -3.34422948279238E-01   0.00000000000000E+00  -1.00349983237015E-13
     -1.24345101670563E-22  -7.89263070806166E-11  -7.90266570639779E-11  -4.02854821740072E-18
      7.54128080169138E-07
      0.00000000000000E+00  -7.96293871589257E-14   0.00000000000000E+00   9.04385425035700E-17   9.45696965128822E-23
      7.96318777590271E-11   7.96319681976642E-11  -1.30484570842831E-18  -6.00017828783104E-03  -6.00017828783472E-03
      0.00000000000000E+00   0.00000000000000E+00   3.67892031783774E-12   0.00000000000000E+00   3.67892031783774E-12
      5.35474893561434E-18  -3.46608017418621E-01  -3.46581772122748E-01   0.00000000000000E+00  -9.38229477271611E-14
     -1.25426937492904E-22  -8.32170655676491E-11  -8.33108885155017E-11  -4.04990322718604E-18
      7.59128080169138E-07
      0.00000000000000E+00  -8.70688108727354E-14   0.00000000000000E+00   1.47911345868119E-16   9.88784542291322E-23
      8.70621966164026E-11   8.70623445278473E-11  -1.29972570125784E-18  -7.73244833494428E-03  -7.73244833494693E-03
      0.00000000000000E+00   0.00000000000000E+00   2.65260906659352E-12   0.00000000000000E+00   2.65260906659352E-12
      5.36801198094731E-18  -3.58168074641860E-01  -3.58139812006836E-01   0.00000000000000E+00  -8.25198245625145E-14
     -1.26367992335955E-22  -8.96324337697519E-11  -8.97149535944408E-11  -4.06828627968947E-18
      7.64128080169138E-07
      0.00000000000000E+00  -1.01212900402694E-13   0.00000000000000E+00   2.86343976318281E-16   1.06083712884642E-22
      1.01210961789857E-10   1.01211248133940E-10  -1.28956584942861E-18  -1.16494633159404E-02  -1.16494633159410E-02
      0.00000000000000E+00   0.00000000000000E+00   5.82191601407696E-13   0.00000000000000E+00   5.82191601407696E-13
      5.37092293895435E-18  -3.69125307515385E-01  -3.69093239959190E-01   0.00000000000000E+00  -5.94034521558291E-14
     -1.27035745718634E-22  -1.01734036283064E-10  -1.01793439735347E-10  -4.08135708952575E-18
      7.69128080169138E-07
      0.00000000000000E+00  -1.33358558425329E-13   0.00000000000000E+00   6.11597351858862E-16   1.19356782191171E-22
      1.33388486731072E-10   1.33389098328543E-10  -1.26852165317347E-18  -2.01855531739203E-02  -2.01855531739167E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.63818485496895E-12   0.00000000000000E+00  -3.63818485496895E-12
      5.35273201467951E-18  -3.79431645504405E-01  -3.79390770738481E-01   0.00000000000000E+00  -1.31953217080347E-14
     -1.27170428696860E-22  -1.29737718151739E-10  -1.29750913473574E-10  -4.08421036150604E-18
      7.74128080169138E-07
      0.00000000000000E+00  -2.08946777147123E-13   0.00000000000000E+00   1.23572613720907E-15   1.39681939296373E-22
      2.09007057381100E-10   2.09008293107377E-10  -1.23038570162390E-18  -3.57364758841692E-02  -3.57364758841589E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.03261509827556E-11   0.00000000000000E+00  -1.03261509827556E-11
      5.30110125976573E-18  -3.88923567742723E-01  -3.88860977896747E-01   0.00000000000000E+00   5.32085300011609E-14
     -1.26542949149369E-22  -1.98735350654496E-10  -1.98682142124622E-10  -4.07071555814183E-18
      7.79128080169138E-07
      0.00000000000000E+00  -3.69123998837050E-13   0.00000000000000E+00   2.27754804890522E-15   1.60426390126127E-22
      3.69127448131590E-10   3.69129725679800E-10  -1.17753244490687E-18  -5.71152712169095E-02  -5.71152712168926E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.68819259728448E-11   0.00000000000000E+00  -1.68819259728448E-11
      5.21669162990150E-18  -3.97239299548550E-01  -3.97128332244573E-01   0.00000000000000E+00   1.03047782622185E-13
     -1.25334039460928E-22  -3.52350847489452E-10  -3.52247799706955E-10  -4.03915918499463E-18
      7.84128080169138E-07
      0.00000000000000E+00  -6.68537842133587E-13   0.00000000000000E+00   3.60995605790130E-15   1.76201002373255E-22
      6.68494787017370E-10   6.68498396973604E-10  -1.11941236958615E-18  -8.08648703533481E-02  -8.08648703533269E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.12581996256012E-11   0.00000000000000E+00  -2.12581996256012E-11
      5.11040063177350E-18  -4.03766036064025E-01  -4.03562137214357E-01   0.00000000000000E+00   1.21308020173728E-13
     -1.23893879796969E-22  -6.47361505368053E-10  -6.47240197348003E-10  -3.99098826218736E-18
      7.89128080169138E-07
      0.00000000000000E+00  -1.17037748623551E-12   0.00000000000000E+00   5.50100129837919E-15   1.87900579376343E-22
      1.17038560412596E-09   1.17039110512745E-09  -1.06348610840624E-18  -1.04692739003876E-01  -1.04692739003852E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.41925388632961E-11   0.00000000000000E+00  -2.41925388632961E-11
      4.98943793745702E-18  -4.07624591333576E-01  -4.07263504412664E-01   0.00000000000000E+00   1.26400309081578E-13
     -1.22360510136236E-22  -1.14632496657311E-09  -1.14619856626415E-09  -3.92595182905078E-18
      7.94128080169138E-07
      0.00000000000000E+00  -1.93250511558357E-12   0.00000000000000E+00   8.00029070338755E-15   1.97083084898901E-22
      1.93253418584279E-09   1.93254218613369E-09  -1.01279728610660E-18  -1.27729463849863E-01  -1.27729463849836E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.68614971795591E-11   0.00000000000000E+00  -2.68614971795591E-11
      4.85513045155922E-18  -4.07709982264416E-01  -4.07109632016484E-01   0.00000000000000E+00   1.33513923287757E-13
     -1.20696698009176E-22  -1.90581420287730E-09  -1.90568068895413E-09  -3.84233316545262E-18
      7.99128080169138E-07
      0.00000000000000E+00  -2.99129124611194E-12   0.00000000000000E+00   1.08640887514653E-14   2.03939400029166E-22
      2.99131714639614E-09   2.99132801048509E-09  -9.67613000048401E-19  -1.49767396620100E-01  -1.49767396620070E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.97089157796144E-11   0.00000000000000E+00  -2.97089157796144E-11
      4.70658587266115E-18  -4.02798938615016E-01  -4.01865927770541E-01   0.00000000000000E+00   1.48790798217172E-13
     -1.18789353972889E-22  -2.96176788550358E-09  -2.96161909470548E-09  -3.73897287261275E-18
      8.04128080169138E-07
      0.00000000000000E+00  -4.35141995941820E-12   0.00000000000000E+00   1.37832039356688E-14   2.07869328730215E-22
      4.35143592286886E-09   4.35144970607300E-09  -9.27206385478466E-19  -1.70775420469810E-01  -1.70775420469778E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.25742586610311E-11   0.00000000000000E+00  -3.25742586610311E-11
      4.54371457935600E-18  -3.91701476773816E-01  -3.90340873350330E-01   0.00000000000000E+00   1.73697665292080E-13
     -1.16497038184992E-22  -4.31904914507715E-09  -4.31887544741197E-09  -3.61650819387752E-18
      8.09128080169138E-07
      0.00000000000000E+00  -5.99020560541210E-12   0.00000000000000E+00   1.64878600149801E-14   2.08332925010075E-22
      5.99017293013671E-09   5.99018941799693E-09  -8.90653420014506E-19  -1.90776131924862E-01  -1.90776131924827E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.51629401110836E-11   0.00000000000000E+00  -3.51629401110836E-11
      4.36789987880058E-18  -3.73387986858234E-01  -3.71511918702447E-01   0.00000000000000E+00   2.07528597793727E-13
     -1.13666884970352E-22  -5.95523400648354E-09  -5.95502647788586E-09  -3.47724645878607E-18
      8.14128080169138E-07
      0.00000000000000E+00  -7.86677727603629E-12   0.00000000000000E+00   1.88000051250142E-14   2.05380338487909E-22
      7.86680810662712E-09   7.86682690663245E-09  -8.57129460912880E-19  -2.09810268395018E-01  -2.09810268394981E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.72621557371141E-11   0.00000000000000E+00  -3.72621557371141E-11
      4.18158910011501E-18  -3.47069481155065E-01  -3.44602832097496E-01   0.00000000000000E+00   2.46895477292026E-13
     -1.10147554429099E-22  -7.82981164637252E-09  -7.82956475089534E-09  -3.32445963920212E-18
      8.19128080169138E-07
      0.00000000000000E+00  -9.92391570001047E-12   0.00000000000000E+00   2.05532890097540E-14   1.99873295202130E-22
      9.92393650617577E-09   9.92395705946498E-09  -8.25992882770190E-19  -2.27922706264325E-01  -2.27922706264286E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.88361758999344E-11   0.00000000000000E+00  -3.88361758999344E-11
      3.98740822061533E-18  -3.12273741253747E-01  -3.09159463235704E-01   0.00000000000000E+00   2.83817882957017E-13
     -1.05790922626966E-22  -9.88540470144789E-09  -9.88512088356504E-09  -3.16141533784514E-18
      8.24128080169138E-07
      0.00000000000000E+00  -1.20615101137785E-11   0.00000000000000E+00   2.13249901641392E-14   1.92642312875674E-22
      1.20615092639152E-08   1.20615305889055E-08  -7.96825912834801E-19  -2.45156647378511E-01  -2.45156647378471E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.01778093454010E-11   0.00000000000000E+00  -4.01778093454010E-11
      3.78651917388833E-18  -2.69039091480947E-01  -2.65251745592834E-01   0.00000000000000E+00   3.02843011451213E-13
     -1.00428141147289E-22  -1.20216556225715E-08  -1.20213527795602E-08  -2.98969326105352E-18
      8.29128080169138E-07
      0.00000000000000E+00  -1.40612455769979E-11   0.00000000000000E+00   1.99455111244216E-14   1.81022324991099E-22
      1.40612648110501E-08   1.40612847565614E-08  -7.69514804844482E-19  -2.61549759803036E-01  -2.61549759802994E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.21673149447473E-11   0.00000000000000E+00  -4.21673149447473E-11
      3.57568259916459E-18  -2.18427533138157E-01  -2.14010726575037E-01   0.00000000000000E+00   2.84211295907293E-13
     -9.40664324432975E-23  -1.40194016529125E-08  -1.40191174416167E-08  -2.80616779432011E-18
      8.34128080169138E-07
      0.00000000000000E+00  -1.55996449252240E-11   0.00000000000000E+00   1.53856997720638E-14   1.56945569755437E-22
      1.55995568485796E-08   1.55995722342795E-08  -7.44136085364006E-19  -2.77135463912925E-01  -2.77135463912880E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.53963462898215E-11   0.00000000000000E+00  -4.53963462898215E-11
      3.34870086771548E-18  -1.62948501949944E-01  -1.58048010460758E-01   0.00000000000000E+00   2.28609888050141E-13
     -8.77472738254746E-23  -1.55544044978777E-08  -1.55541758879897E-08  -2.60456478235148E-18
      8.39128080169138E-07
      0.00000000000000E+00  -1.64453512654309E-11   0.00000000000000E+00   8.51649280331251E-15   1.18673900973415E-22
      1.64453275568591E-08   1.64453360733520E-08  -7.20458797627690E-19  -2.91955627086438E-01  -2.91955627086390E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.77902646700328E-11   0.00000000000000E+00  -4.77902646700328E-11
      3.10974954436532E-18  -1.06073332919390E-01  -1.00907085161033E-01   0.00000000000000E+00   1.74168537554344E-13
     -8.18094787519059E-23  -1.63977199772195E-08  -1.63975458086820E-08  -2.38929074673763E-18
      8.44128080169138E-07
      0.00000000000000E+00  -1.55328738012741E-11   0.00000000000000E+00   2.54239858351304E-13   6.77949909636742E-23
      1.55328562079529E-08   1.55331104478113E-08  -6.98007629885974E-19  -3.06061008991663E-01  -3.06061008991616E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.70651832279648E-11   0.00000000000000E+00  -4.70651832279648E-11
      2.87442362822550E-18  -5.61741001137116E-02  -5.12950851149264E-02   0.00000000000000E+00  -1.32162017726443E-13
     -6.11023303821564E-23  -1.54859131025656E-08  -1.54860452645834E-08  -2.17641599833952E-18
      8.49128080169138E-07
      0.00000000000000E+00  -1.17243480834896E-11   0.00000000000000E+00  -3.74299571558364E-14   3.02695531441639E-23
      1.17243919261330E-08   1.17243544961758E-08  -6.73836368732180E-19  -3.19529718681234E-01  -3.19529718681197E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.69267679299760E-11   0.00000000000000E+00  -3.69267679299760E-11
      2.68978978857562E-18  -2.66210222898290E-02  -2.29387190163395E-02   0.00000000000000E+00   1.04877910174197E-13
     -2.99662676890089E-23  -1.16875326061560E-08  -1.16874277282459E-08  -2.01595341984344E-18
      8.54128080169137E-07
      0.00000000000000E+00  -8.38138333861006E-12   0.00000000000000E+00  -3.28180515045067E-14   1.46397978327632E-23
      8.38133372666202E-09   8.38130090861053E-09  -6.47025155675079E-19  -3.32397988718668E-01  -3.32397988718642E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.53234784815140E-11   0.00000000000000E+00  -2.53234784815140E-11
      2.56317239616805E-18  -1.42488132332534E-02  -1.16161295759283E-02   0.00000000000000E+00   6.69975514157821E-14
     -1.50298648170999E-23  -8.35604442768041E-09  -8.35597743012901E-09  -1.91614724049297E-18
      8.59128080169137E-07
      0.00000000000000E+00  -6.87558887209266E-12   0.00000000000000E+00  -1.46971234593499E-14   8.85890780951556E-24
      6.87555943260802E-09   6.87554473548457E-09  -6.19387200033465E-19  -3.44665470075130E-01  -3.44665470075111E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.93999634922047E-11   0.00000000000000E+00  -1.93999634922047E-11
      2.46617257870702E-18  -9.56249926013178E-03  -7.40235920170339E-03   0.00000000000000E+00   3.60813267457620E-14
     -9.74301032167381E-24  -6.85618085331910E-09  -6.85614477199236E-09  -1.84678537867356E-18
      8.64128080169137E-07
      0.00000000000000E+00  -6.35528843581202E-12   0.00000000000000E+00  -4.99022309891229E-15   6.36100182855784E-24
      6.35525581762462E-09   6.35525082740153E-09  -5.92030778218845E-19  -3.56340068717005E-01  -3.56340068716988E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.69232064297162E-11   0.00000000000000E+00  -1.69232064297162E-11
      2.38155654655844E-18  -7.54513905138662E-03  -5.54814389485407E-03   0.00000000000000E+00   2.14525472588241E-14
     -7.49148845960969E-24  -6.33834907351906E-09  -6.33832762097181E-09  -1.78952576833960E-18
      8.69128080169137E-07
      0.00000000000000E+00  -6.18115081406655E-12   0.00000000000000E+00  -1.80562162785139E-15   5.01917062850792E-24
      6.18110976662773E-09   6.18110796100611E-09  -5.65410192997288E-19  -3.67432886930763E-01  -3.67432886930748E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.57204761443611E-11   0.00000000000000E+00  -1.57204761443611E-11
      2.30295416583664E-18  -6.43809386343160E-03  -4.49558478333166E-03   0.00000000000000E+00   1.57640077168894E-14
     -6.07225927811446E-24  -6.16540324886946E-09  -6.16538748486175E-09  -1.73754397283935E-18
      8.74128080169137E-07
      0.00000000000000E+00  -6.11134881378883E-12   0.00000000000000E+00  -5.72687831931796E-16   4.13232446512920E-24
      6.11131787784962E-09   6.11131730516180E-09  -5.39789796334229E-19  -3.77938223855337E-01  -3.77938223855322E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.49269687116778E-11   0.00000000000000E+00  -1.49269687116778E-11
      2.22831932227825E-18  -5.70735666019372E-03  -3.78658504956998E-03   0.00000000000000E+00   1.27802835150610E-14
     -5.13605719433794E-24  -6.09640311673364E-09  -6.09639033645013E-09  -1.68852952594402E-18
      8.79128080169137E-07
      0.00000000000000E+00  -6.07396800574537E-12   0.00000000000000E+00  -2.60402815676047E-16   3.50703979683635E-24
      6.07393778885493E-09   6.07393752845211E-09  -5.15495866262568E-19  -3.87792871782285E-01  -3.87792871782271E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.41892448781397E-11   0.00000000000000E+00  -1.41892448781397E-11
      2.15737309788755E-18  -5.18276035403611E-03  -3.27353230444000E-03   0.00000000000000E+00   1.09615806178743E-14
     -4.44136415231333E-24  -6.05975924515458E-09  -6.05974828357397E-09  -1.64187723162498E-18
      8.84128080169137E-07
      0.00000000000000E+00  -6.04843516880167E-12   0.00000000000000E+00  -1.60834702921171E-16   3.05548242955743E-24
      6.04841108890781E-09   6.04841092807311E-09  -4.93148588550264E-19  -3.96798369946258E-01  -3.96798369946245E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.32025581134740E-11   0.00000000000000E+00  -1.32025581134740E-11
      2.09136030732018E-18  -4.79769685548373E-03  -2.89619954768157E-03   0.00000000000000E+00   9.36462700941435E-15
     -3.92438252872797E-24  -6.03521773458664E-09  -6.03520836995963E-09  -1.59821171876992E-18
      8.89128080169137E-07
      0.00000000000000E+00  -6.02758641345557E-12   0.00000000000000E+00  -3.28684380066035E-16   2.73233637159541E-24
      6.02754024049974E-09   6.02753991181536E-09  -4.73863055383154E-19  -4.04544121641578E-01  -4.04544121641567E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15761021843660E-11   0.00000000000000E+00  -1.15761021843660E-11
      2.03347979639835E-18  -4.52071044354880E-03  -2.62527561009261E-03   0.00000000000000E+00   7.83036601003382E-15
     -3.55583554964468E-24  -6.01597163999700E-09  -6.01596380963100E-09  -1.55961674101519E-18
      8.94128080169137E-07
      0.00000000000000E+00  -6.00765610548153E-12   0.00000000000000E+00  -7.93268094995132E-17   2.51398220609962E-24
      6.00762686868306E-09   6.00762678935626E-09  -4.59353851589561E-19  -4.10365003151143E-01  -4.10365003151134E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.85074332475605E-12   0.00000000000000E+00  -8.85074332475605E-12
      1.98922607977457E-18  -4.33707782012039E-03  -2.44705779971380E-03   0.00000000000000E+00   5.47521420136884E-15
     -3.32574854570198E-24  -5.99878152124570E-09  -5.99877604603150E-09  -1.52987222818501E-18
      8.99128080169137E-07
      0.00000000000000E+00  -5.98579705802614E-12   0.00000000000000E+00  -1.88590076321006E-16   2.39094960697131E-24
      5.98577245217117E-09   5.98577226358109E-09  -4.51950590894513E-19  -4.13334917713589E-01  -4.13334917713584E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.57267088628284E-12   0.00000000000000E+00  -4.57267088628284E-12
      1.96636272534315E-18  -4.24432197729922E-03  -2.35983942428885E-03   0.00000000000000E+00   2.84332728117504E-15
     -3.24266868102666E-24  -5.98120243602209E-09  -5.98119959269481E-09  -1.51441213444864E-18
      9.04128080169137E-07
      0.00000000000000E+00  -5.95861101581271E-12   0.00000000000000E+00  -2.76600218465697E-16   2.36672605613345E-24
      5.95864537432770E-09   5.95864509772748E-09  -4.54489805348182E-19  -4.12315992121490E-01  -4.12315992121491E-01
      0.00000000000000E+00   0.00000000000000E+00   1.55959680701174E-12   0.00000000000000E+00   1.55959680701174E-12
      1.97416070937821E-18  -4.25446990442230E-03  -2.37660225468173E-03   0.00000000000000E+00  -6.91901219692765E-16
     -3.34415493877567E-24  -5.96020400263327E-09  -5.96020469453449E-09  -1.51967090403003E-18
      9.09128080169137E-07
      0.00000000000000E+00  -5.92086282882042E-12   0.00000000000000E+00  -4.29869081699598E-16   2.46181499669282E-24
      5.92084351863674E-09   5.92084308876766E-09  -4.70039216124998E-19  -4.06078632081802E-01  -4.06078632081812E-01
      0.00000000000000E+00   0.00000000000000E+00   9.50125401436550E-12   0.00000000000000E+00   9.50125401436550E-12
      2.02166697945004E-18  -4.40472691835706E-03  -2.53626788567118E-03   0.00000000000000E+00  -5.37287518176486E-15
     -3.72797409970020E-24  -5.93033896990684E-09  -5.93034434278202E-09  -1.55162776332504E-18
      9.14128080169137E-07
      0.00000000000000E+00  -5.86079637068670E-12   0.00000000000000E+00  -7.13905976608134E-16   2.72508520447396E-24
      5.86076027018586E-09   5.86075955627989E-09  -5.01471412025777E-19  -3.93454114704332E-01  -3.93454114704350E-01
      0.00000000000000E+00   0.00000000000000E+00   1.87727572496786E-11   0.00000000000000E+00   1.87727572496786E-11
      2.11553076569843E-18  -4.78780628769866E-03  -2.93535773857902E-03   0.00000000000000E+00  -1.16529027207872E-14
     -4.64145542686669E-24  -5.87952066062685E-09  -5.87953231352957E-09  -1.61405935367266E-18
      9.19128080169137E-07
      0.00000000000000E+00  -5.74856210181910E-12   0.00000000000000E+00  -1.31545281030927E-15   3.25546150286337E-24
      5.74853084010465E-09   5.74852952465185E-09  -5.50840992558043E-19  -3.73452964427886E-01  -3.73452964427914E-01
      0.00000000000000E+00   0.00000000000000E+00   2.86761384278286E-11   0.00000000000000E+00   2.86761384278286E-11
      2.25891145783758E-18  -5.63700226410476E-03  -3.81679567055026E-03   0.00000000000000E+00  -2.02787631383629E-14
     -6.74665509801202E-24  -5.77718538431654E-09  -5.77720566307968E-09  -1.70807046527953E-18
      9.24128080169137E-07
      0.00000000000000E+00  -5.50241820610293E-12   0.00000000000000E+00  -4.24085333311266E-15   4.22068755506844E-24
      5.50238866860474E-09   5.50238442775141E-09  -6.18288878946074E-19  -3.45338173427190E-01  -3.45338173427229E-01
      0.00000000000000E+00   0.00000000000000E+00   3.90322264566400E-11   0.00000000000000E+00   3.90322264566400E-11
      2.45407259012078E-18  -7.56322575680520E-03  -5.81731138674085E-03   0.00000000000000E+00  -3.08914766055833E-14
     -1.18648241395382E-23  -5.54138576273144E-09  -5.54141665420806E-09  -1.83578371117470E-18
      9.29128080169137E-07
      0.00000000000000E+00  -4.92058179589325E-12   0.00000000000000E+00  -6.21699318731604E-15   5.73872657472882E-24
      4.92060107158898E-09   4.92059485459580E-09  -7.00681531620453E-19  -3.08705686371298E-01  -3.08705686371349E-01
      0.00000000000000E+00   0.00000000000000E+00   5.14277142115591E-11   0.00000000000000E+00   5.14277142115591E-11
      2.71121116117857E-18  -1.20976238493968E-02  -1.05311115204121E-02   0.00000000000000E+00  -4.93709120860000E-14
     -2.42483534038468E-23  -4.97197319789525E-09  -4.97202256880736E-09  -2.01052962955812E-18
      9.34128080169137E-07
      0.00000000000000E+00  -3.70501669895163E-12   0.00000000000000E+00  -1.25250497950529E-14   6.90810213928119E-24
      3.70501718101236E-09   3.70500465596257E-09  -7.92702849549810E-19  -2.63710421756950E-01  -2.63710421757018E-01
      0.00000000000000E+00   0.00000000000000E+00   6.79571284015070E-11   0.00000000000000E+00   6.79571284015070E-11
      3.05099680318611E-18  -2.21022560049513E-02  -2.09135315523268E-02   0.00000000000000E+00  -7.39707844260761E-14
     -4.80582662204048E-23  -3.77288781357960E-09  -3.77296178436408E-09  -2.25829395363629E-18
      9.39128080169137E-07
      0.00000000000000E+00  -2.02343140541902E-12   0.00000000000000E+00  -1.75137041263489E-14   3.04944494533359E-24
      2.02348714998210E-09   2.02346963627798E-09  -8.92175026927206E-19  -2.11637086978542E-01  -2.11637086978625E-01
      0.00000000000000E+00   0.00000000000000E+00   8.35388811552331E-11   0.00000000000000E+00   8.35388811552331E-11
      3.46869120896227E-18  -3.95292972222564E-02  -3.88654587946061E-02   0.00000000000000E+00  -1.12726309398158E-13
     -7.41598321747499E-23  -2.10689579112374E-09  -2.10700851743321E-09  -2.57651618203506E-18
      9.44128080169137E-07
      0.00000000000000E+00  -7.73424532024583E-13   0.00000000000000E+00  -1.33732054888892E-14  -9.99455696405597E-24
      7.73464556427796E-10   7.73451183222297E-10  -1.00093382252174E-18  -1.55200070676227E-01  -1.55200070676315E-01
      0.00000000000000E+00   0.00000000000000E+00   8.85922203407797E-11   0.00000000000000E+00   8.85922203407797E-11
      3.91165231066617E-18  -6.20256048858422E-02  -6.17540099335729E-02   0.00000000000000E+00  -1.71525991143643E-13
     -8.75960477239825E-23  -8.61871877571846E-10  -8.62043403563077E-10  -2.91071848814443E-18
      9.49128080169137E-07
      0.00000000000000E+00  -2.24193003523573E-13   0.00000000000000E+00  -6.74037545711081E-15  -2.57576161040628E-23
      2.24184216229530E-10   2.24177475854048E-10  -1.11767783181691E-18  -9.81653631081465E-02  -9.81653631082288E-02
      0.00000000000000E+00   0.00000000000000E+00   8.23221182542409E-11   0.00000000000000E+00   8.23221182542409E-11
      4.32326290193737E-18  -8.60778317125615E-02  -8.59812669312931E-02   0.00000000000000E+00  -2.45246050045633E-13
     -9.41715053006376E-23  -3.06254348058149E-10  -3.06499594108289E-10  -3.20558507012046E-18
      9.54128080169136E-07
      0.00000000000000E+00  -6.38320923592311E-14   0.00000000000000E+00  -2.80778309141445E-15  -3.44179639027663E-23
      6.38680256375992E-11   6.38652178544734E-11  -1.22053934194521E-18  -5.03737446718953E-02  -5.03737446719600E-02
      0.00000000000000E+00   0.00000000000000E+00   6.47142796465205E-11   0.00000000000000E+00   6.47142796465205E-11
      4.64683430016998E-18  -1.09818999507215E-01  -1.09778489934436E-01   0.00000000000000E+00  -2.91143447825439E-13
     -9.99784975516242E-23  -1.28288354053069E-10  -1.28579497500994E-10  -3.42629495822477E-18
      9.59128080169136E-07
      0.00000000000000E+00  -3.77481869922935E-14   0.00000000000000E+00  -9.59499491694310E-16  -3.35514659394584E-23
      3.77493977180904E-11   3.77484382185652E-11  -1.27952034111219E-18  -2.39078395653377E-02  -2.39078395653774E-02
      0.00000000000000E+00   0.00000000000000E+00   3.97190082404847E-11   0.00000000000000E+00   3.97190082404847E-11
      4.84542934137240E-18  -1.32660262504889E-01  -1.32635856187762E-01   0.00000000000000E+00  -2.41732108675538E-13
     -1.04282522536488E-22  -7.72257143502699E-11  -7.74674464590497E-11  -3.56590900026021E-18
      9.64128080169136E-07
      0.00000000000000E+00  -3.91258580504064E-14   0.00000000000000E+00  -2.16731143734978E-16  -2.44111163337393E-23
      3.91227368152373E-11   3.91225200840691E-11  -1.30404878867242E-18  -1.32014377647359E-02  -1.32014377647580E-02
      0.00000000000000E+00   0.00000000000000E+00   2.21509940111307E-11   0.00000000000000E+00   2.21509940111307E-11
      4.95618431142805E-18  -1.54477286998586E-01  -1.54457982790841E-01   0.00000000000000E+00  -1.78668511004563E-13
     -1.07156332966399E-22  -6.10948455840880E-11  -6.12735140951998E-11  -3.65213552275564E-18
      9.69128080169136E-07
      0.00000000000000E+00  -4.32588712247451E-14   0.00000000000000E+00  -8.74916069984582E-18  -6.91169582898849E-24
      4.32714443575704E-11   4.32714356084028E-11  -1.31283294663630E-18  -9.13399053374199E-03  -9.13399053375566E-03
      0.00000000000000E+00   0.00000000000000E+00   1.36683329831843E-11   0.00000000000000E+00   1.36683329831843E-11
      5.02452597634398E-18  -1.75262584784266E-01  -1.75244646063383E-01   0.00000000000000E+00  -1.49527745351919E-13
     -1.09400201017415E-22  -5.67902408461255E-11  -5.69397685915869E-11  -3.71169302970767E-18
      9.74128080169136E-07
      0.00000000000000E+00  -4.67489712386311E-14   0.00000000000000E+00   2.94686871099751E-17   1.57248520215055E-23
      4.67886236248933E-11   4.67886530935962E-11  -1.31575796626275E-18  -7.32619340429512E-03  -7.32619340430506E-03
      0.00000000000000E+00   0.00000000000000E+00   9.93555497874845E-12   0.00000000000000E+00   9.93555497874845E-12
      5.07420375123772E-18  -1.95047277189845E-01  -1.95029406500861E-01   0.00000000000000E+00  -1.39255787462819E-13
     -1.11380805180732E-22  -5.65849522847710E-11  -5.67242080723452E-11  -3.75844578497497E-18
      9.79128080169136E-07
      0.00000000000000E+00  -4.97798475664795E-14   0.00000000000000E+00   3.29058357123611E-17   3.70603610081644E-23
      4.97592755159215E-11   4.97593084217943E-11  -1.31658131345828E-18  -6.29977555840554E-03  -6.29977555841372E-03
      0.00000000000000E+00   0.00000000000000E+00   8.17515290699451E-12   0.00000000000000E+00   8.17515290699451E-12
      5.11507951577269E-18  -2.13874706851380E-01  -2.13856454990967E-01   0.00000000000000E+00  -1.34301507967354E-13
     -1.13203553452445E-22  -5.78001598207081E-11  -5.79344613287886E-11  -3.79849820231441E-18
      9.84128080169136E-07
      0.00000000000000E+00  -5.25351896827053E-14   0.00000000000000E+00   3.30975116167245E-17   5.38447825731271E-23
      5.25204528130494E-11   5.25204859106149E-11  -1.31657032371786E-18  -5.60953904995239E-03  -5.60953904995960E-03
      0.00000000000000E+00   0.00000000000000E+00   7.20875934193289E-12   0.00000000000000E+00   7.20875934193289E-12
      5.15112331248235E-18  -2.31790111885684E-01  -2.31771294702778E-01   0.00000000000000E+00  -1.30069148564669E-13
     -1.14900360173580E-22  -5.95991761038678E-11  -5.97292452525474E-11  -3.83455298876449E-18
      9.89128080169136E-07
      0.00000000000000E+00  -5.52905317989311E-14   0.00000000000000E+00   3.46160126059539E-17   6.56387857990617E-23
      5.52532194980652E-11   5.52532541141435E-11  -1.31615572469265E-18  -5.11046545992961E-03  -5.11046545993619E-03
      0.00000000000000E+00   0.00000000000000E+00   6.58336398954689E-12   0.00000000000000E+00   6.58336398954689E-12
      5.18404013243009E-18  -2.48836018090127E-01  -2.48816537110870E-01   0.00000000000000E+00  -1.25699884908068E-13
     -1.16491136491228E-22  -6.17109182186658E-11  -6.18366181036903E-11  -3.86788440773744E-18
      9.94128080169136E-07
      0.00000000000000E+00  -5.80458739151569E-14   0.00000000000000E+00   3.68296728414129E-17   7.35586522958346E-23
      5.80233888091397E-11   5.80234256388861E-11  -1.31549950422604E-18  -4.74378018931951E-03  -4.74378018932563E-03
      0.00000000000000E+00   0.00000000000000E+00   6.11606622849468E-12   0.00000000000000E+00   6.11606622849468E-12
      5.21462046357256E-18  -2.65048689311576E-01  -2.65028482950767E-01   0.00000000000000E+00  -1.21229012683002E-13
     -1.17992176034379E-22  -6.40182628545795E-11  -6.41394918673805E-11  -3.89912095934652E-18
      9.99128080169136E-07
      0.00000000000000E+00  -6.08930607685902E-14   0.00000000000000E+00   3.91247185085639E-17   7.89669326336559E-23
      6.08489424626246E-11   6.08489815874220E-11  -1.31466966436667E-18  -4.48124342166956E-03  -4.48124342167529E-03
      0.00000000000000E+00   0.00000000000000E+00   5.72604528675207E-12   0.00000000000000E+00   5.72604528675207E-12
      5.24325069000632E-18  -2.80462034360262E-01  -2.80441060829453E-01   0.00000000000000E+00  -1.16805319892939E-13
     -1.19415409256811E-22  -6.64582215541621E-11  -6.65750268741745E-11  -3.92858102563965E-18
      1.00412808016914E-06
      0.00000000000000E+00  -6.37402476220236E-14   0.00000000000000E+00   4.13468861582723E-17   8.29005594960158E-23
      6.37406521771494E-11   6.37406935241184E-11  -1.31369234267847E-18  -4.30999920616168E-03  -4.30999920616705E-03
      0.00000000000000E+00   0.00000000000000E+00   5.37747578491579E-12   0.00000000000000E+00   5.37747578491579E-12
      5.27013806893090E-18  -2.95119615984447E-01  -2.95097841387453E-01   0.00000000000000E+00  -1.12605121410581E-13
     -1.20769851153042E-22  -6.90055641875028E-11  -6.91181693090342E-11  -3.95644572625243E-18
      1.00912808016914E-06
      0.00000000000000E+00  -6.66792792126644E-14   0.00000000000000E+00   4.45234882285264E-17   8.60181052100678E-23
      6.67227418793778E-11   6.67227864029521E-11  -1.31256461766035E-18  -4.22917394978733E-03  -4.22917394979238E-03
      0.00000000000000E+00   0.00000000000000E+00   5.05245926615615E-12   0.00000000000000E+00   5.05245926615615E-12
      5.29540036526168E-18  -3.09077183537011E-01  -3.09054571984582E-01   0.00000000000000E+00  -1.08747749242785E-13
     -1.22063096883662E-22  -7.16664979197433E-11  -7.17752456691082E-11  -3.98283574760134E-18
      1.01412808016914E-06
      0.00000000000000E+00  -6.98938450149279E-14   0.00000000000000E+00   4.86647399031321E-17   8.87184958949799E-23
      6.98543107650468E-11   6.98543594298754E-11  -1.31124751058882E-18  -4.25292224598133E-03  -4.25292224598607E-03
      0.00000000000000E+00   0.00000000000000E+00   4.74083274203585E-12   0.00000000000000E+00   4.74083274203585E-12
      5.31910452897186E-18  -3.22412496120585E-01  -3.22388996306912E-01   0.00000000000000E+00  -1.05358592893427E-13
     -1.23302647006032E-22  -7.44898335788945E-11  -7.45951921719113E-11  -4.00785701838304E-18
      1.01912808016914E-06
      0.00000000000000E+00  -7.32921002916063E-14   0.00000000000000E+00   5.52986272041626E-17   9.12548457713415E-23
      7.32479768310382E-11   7.32480321297567E-11  -1.30964430316641E-18  -4.42242812152371E-03  -4.42242812152811E-03
      0.00000000000000E+00   0.00000000000000E+00   4.39995950253168E-12   0.00000000000000E+00   4.39995950253168E-12
      5.34110432648452E-18  -3.35148575474958E-01  -3.35124114048681E-01   0.00000000000000E+00  -1.01718993834623E-13
     -1.24486845416763E-22  -7.75462726383293E-11  -7.76479916322884E-11  -4.03146002331811E-18
      1.02412808016914E-06
      0.00000000000000E+00  -7.71495792543225E-14   0.00000000000000E+00   6.83484970118597E-17   9.38693103388441E-23
      7.71731874076606E-11   7.71732557562515E-11  -1.30752018137044E-18  -4.83973044957604E-03  -4.83973044958001E-03
      0.00000000000000E+00   0.00000000000000E+00   3.97056287764817E-12   0.00000000000000E+00   3.97056287764817E-12
      5.36095714087276E-18  -3.47285167523916E-01  -3.47259604923819E-01   0.00000000000000E+00  -9.70483434887436E-14
     -1.25604975164164E-22  -8.10467702902852E-11  -8.11438186338995E-11  -4.05343695950233E-18
      1.02912808016914E-06
      0.00000000000000E+00  -8.23847292751515E-14   0.00000000000000E+00   9.73125038553304E-17   9.69909374589591E-23
      8.23471488787531E-11   8.23472461913540E-11  -1.30427947291612E-18  -5.76281152095402E-03  -5.76281152095735E-03
      0.00000000000000E+00   0.00000000000000E+00   3.32644441406924E-12   0.00000000000000E+00   3.32644441406924E-12
      5.37758936294311E-18  -3.58832186832297E-01  -3.58805197312062E-01   0.00000000000000E+00  -8.99271478918792E-14
     -1.26630301173604E-22  -8.55837634574044E-11  -8.56736906054229E-11  -4.07330989002698E-18
      1.03412808016914E-06
      0.00000000000000E+00  -9.08344450982440E-14   0.00000000000000E+00   1.73569129053131E-16   1.01663584205493E-22
      9.08147862496662E-11   9.08149598188969E-11  -1.29835262879941E-18  -7.86893889003679E-03  -7.86893889003891E-03
      0.00000000000000E+00   0.00000000000000E+00   2.11814664400180E-12   0.00000000000000E+00   2.11814664400180E-12
      5.38818009616312E-18  -3.69799872446416E-01  -3.69770596138264E-01   0.00000000000000E+00  -7.62420805461977E-14
     -1.27489794765094E-22  -9.28568643822247E-11  -9.29331064628984E-11  -4.08982746736371E-18
      1.03912808016914E-06
      0.00000000000000E+00  -1.08560479379297E-13   0.00000000000000E+00   3.56265378342283E-16   1.10361148267119E-22
      1.08570190147206E-10   1.08570546412695E-10  -1.28581594356452E-18  -1.28308986699855E-02  -1.28308986699850E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.11269603591748E-13   0.00000000000000E+00  -5.11269603591748E-13
      5.38562374814516E-18  -3.80176841813224E-01  -3.80142800499102E-01   0.00000000000000E+00  -4.60791616639010E-14
     -1.27999635187632E-22  -1.08013197647311E-10  -1.08059276809103E-10  -4.09980780458064E-18
      1.04412808016914E-06
      0.00000000000000E+00  -1.51543816392419E-13   0.00000000000000E+00   7.82919163192566E-16   1.26642092639203E-22
      1.51573758409547E-10   1.51574541328836E-10  -1.25948870734331E-18  -2.36027023836418E-02  -2.36027023836360E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.80036659941181E-12   0.00000000000000E+00  -5.80036659941181E-12
      5.35662191514810E-18  -3.89883645677363E-01  -3.89837723333604E-01   0.00000000000000E+00   1.22665848592256E-14
     -1.27844018055774E-22  -1.45786441314156E-10  -1.45774174729425E-10  -4.09713320780479E-18
      1.04912808016914E-06
      0.00000000000000E+00  -2.51746424685831E-13   0.00000000000000E+00   1.54730360469873E-15   1.48857644976117E-22
      2.51777703322771E-10   2.51779250626524E-10  -1.21491160391352E-18  -4.17596189430323E-02  -4.17596189430193E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.30649544895706E-11   0.00000000000000E+00  -1.30649544895706E-11
      5.29129714270024E-18  -3.98690700815299E-01  -3.98615499957764E-01   0.00000000000000E+00   8.13740632096447E-14
     -1.26899234587866E-22  -2.38795670200037E-10  -2.38714296136954E-10  -4.07638553878673E-18
      1.05412808016914E-06
      0.00000000000000E+00  -4.54998828126088E-13   0.00000000000000E+00   2.63417331233792E-15   1.68393720764888E-22
      4.55030008140281E-10   4.55032642313761E-10  -1.15853537041934E-18  -6.45739221945080E-02  -6.45739221944891E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.89564000989966E-11   0.00000000000000E+00  -1.89564000989966E-11
      5.19651514220526E-18  -4.06147011445401E-01  -4.06009636005614E-01   0.00000000000000E+00   1.19253343349437E-13
     -1.25508864455243E-22  -4.36195495557989E-10  -4.36076242214765E-10  -4.03797977178593E-18
      1.05912808016914E-06
      0.00000000000000E+00  -8.19714279577176E-13   0.00000000000000E+00   4.19186161025528E-15   1.82471501931954E-22
      8.19685160252831E-10   8.19689352114624E-10  -1.10022874039111E-18  -8.86549294165318E-02  -8.86549294165092E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.26024640173981E-11   0.00000000000000E+00  -2.26024640173981E-11
      5.08350282211827E-18  -4.11543238322982E-01  -4.11292133544370E-01   0.00000000000000E+00   1.28813951215000E-13
     -1.23981515094526E-22  -7.97215702048316E-10  -7.97086888097225E-10  -3.98327408172717E-18
      1.06412808016914E-06
      0.00000000000000E+00  -1.40853088981463E-12   0.00000000000000E+00   6.37412279799227E-15   1.93095957858351E-22
      1.40850754452564E-09   1.40851391864863E-09  -1.04581867500340E-18  -1.12314699884070E-01  -1.12314699884045E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.52796339928232E-11   0.00000000000000E+00  -2.52796339928232E-11
      4.95710465215416E-18  -4.13913115420524E-01  -4.13477355071077E-01   0.00000000000000E+00   1.32174725639705E-13
     -1.22374871208999E-22  -1.38336645938133E-09  -1.38323428465581E-09  -3.91128597715076E-18
      1.06912808016914E-06
      0.00000000000000E+00  -2.27380015904674E-12   0.00000000000000E+00   8.99576314771177E-15   2.01461541805013E-22
      2.27378147664234E-09   2.27379047240569E-09  -9.97010053277149E-19  -1.35049091716320E-01  -1.35049091716292E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.79824095797430E-11   0.00000000000000E+00  -2.79824095797430E-11
      4.81719260425544E-18  -4.12093378067096E-01  -4.11385876492686E-01   0.00000000000000E+00   1.41308730847487E-13
     -1.20609349870636E-22  -2.24594937155668E-09  -2.24580806282595E-09  -3.82018255097829E-18
      1.07412808016914E-06
      0.00000000000000E+00  -3.44114676895440E-12   0.00000000000000E+00   1.19161052592892E-14   2.07330679309027E-22
      3.44115053927897E-09   3.44116245538443E-09  -9.53541596202277E-19  -1.56754922169145E-01  -1.56754922169114E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.08634291084034E-11   0.00000000000000E+00  -3.08634291084034E-11
      4.66287545871342E-18  -4.04854209133999E-01  -4.03779847835620E-01   0.00000000000000E+00   1.59621644396789E-13
     -1.18556920338762E-22  -3.41045864792031E-09  -3.41029902627604E-09  -3.70933386251115E-18
      1.07912808016914E-06
      0.00000000000000E+00  -4.90450896688193E-12   0.00000000000000E+00   1.47854092783792E-14   2.10007778316406E-22
      4.90447693894661E-09   4.90449172435610E-09  -9.14548115011662E-19  -1.77431120582357E-01  -1.77431120582323E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.36662624518090E-11   0.00000000000000E+00  -3.36662624518090E-11
      4.49454414645438E-18  -3.91049773904357E-01  -3.89515283753741E-01   0.00000000000000E+00   1.87720065465981E-13
     -1.16069603624622E-22  -4.87101318196964E-09  -4.87082546190429E-09  -3.57999603144272E-18
      1.08412808016914E-06
      0.00000000000000E+00  -6.63357798955083E-12   0.00000000000000E+00   1.73660723400783E-14   2.09076526856888E-22
      6.63352104629716E-09   6.63353841236971E-09  -8.79115878378999E-19  -1.97111020326983E-01  -1.97111020326947E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.61061894577815E-11   0.00000000000000E+00  -3.61061894577815E-11
      4.31401319916547E-18  -3.69728175653711E-01  -3.67649719726997E-01   0.00000000000000E+00   2.24071540655281E-13
     -1.12993659039871E-22  -6.59765629445246E-09  -6.59743222291192E-09  -3.43489732078647E-18
      1.08912808016914E-06
      0.00000000000000E+00  -8.58243146835734E-12   0.00000000000000E+00   1.94340654582295E-14   2.04860733958501E-22
      8.58245623466899E-09   8.58247566873465E-09  -8.46475092755774E-19  -2.15838512338629E-01  -2.15838512338591E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.80140649862257E-11   0.00000000000000E+00  -3.80140649862257E-11
      4.12394287423434E-18  -3.40200352374217E-01  -3.37508471984443E-01   0.00000000000000E+00   2.64206069031320E-13
     -1.09180683473364E-22  -8.54472580981735E-09  -8.54446160374843E-09  -3.27746778147857E-18
      1.09412808016914E-06
      0.00000000000000E+00  -1.06857677951469E-11   0.00000000000000E+00   2.10006311470224E-14   1.98468773179141E-22
      1.06857221224816E-08   1.06857431231129E-08  -8.16049372126740E-19  -2.33658732965724E-01  -2.33658732965685E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.94283428681698E-11   0.00000000000000E+00  -3.94283428681698E-11
      3.92680115989349E-18  -3.02131585168596E-01  -2.98777482761875E-01   0.00000000000000E+00   2.97922459046581E-13
     -1.04480561180453E-22  -1.06466127027037E-08  -1.06463147802447E-08  -3.11075178776675E-18
      1.09912808016914E-06
      0.00000000000000E+00  -1.28174841457336E-11   0.00000000000000E+00   2.12610673778013E-14   1.90300166628538E-22
      1.28174791780637E-08   1.28175004391313E-08  -7.87505562818120E-19  -2.50613697652074E-01  -2.50613697652034E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.07966330104158E-11   0.00000000000000E+00  -4.07966330104158E-11
      3.72281799484142E-18  -2.55811906589671E-01  -2.51786569726551E-01   0.00000000000000E+00   3.07327629829647E-13
     -9.87275538983906E-23  -1.27770111337506E-08  -1.27767038061209E-08  -2.93531243202330E-18
      1.10412808016914E-06
      0.00000000000000E+00  -1.47082917506250E-11   0.00000000000000E+00   1.88640700082952E-14   1.75690409325987E-22
      1.47082899830076E-08   1.47083088470777E-08  -7.60833538149305E-19  -2.66738931345061E-01  -2.66738931345018E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.31707458278337E-11   0.00000000000000E+00  -4.31707458278337E-11
      3.50696426570225E-18  -2.02773869583597E-01  -1.98153513397894E-01   0.00000000000000E+00   2.74235883409137E-13
     -9.21220424992479E-23  -1.46654123371332E-08  -1.46651381012499E-08  -2.74613072755294E-18
      1.10912808016914E-06
      0.00000000000000E+00  -1.60518884112339E-11   0.00000000000000E+00   1.37194279958236E-14   1.46746281266112E-22
      1.60519127336914E-08   1.60519264531195E-08  -7.36060716094509E-19  -2.82069032561922E-01  -2.82069032561876E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.64482349901289E-11   0.00000000000000E+00  -4.64482349901289E-11
      3.27472309075160E-18  -1.45893533221785E-01  -1.40850840297129E-01   0.00000000000000E+00   2.12596291371647E-13
     -8.60874305513839E-23  -1.60056908144207E-08  -1.60054782181294E-08  -2.53866237465710E-18
      1.11412808016913E-06
      0.00000000000000E+00  -1.65435332895058E-11   0.00000000000000E+00   2.25743146788474E-13   1.03834439184284E-22
      1.65435108785440E-08   1.65437366216909E-08  -7.12915513766700E-19  -2.96648338033032E-01  -2.96648338032984E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.82599235735969E-11   0.00000000000000E+00  -4.82599235735969E-11
      3.03342347288362E-18  -8.93515036529506E-02  -8.41544600402488E-02   0.00000000000000E+00  -6.06252582396082E-14
     -7.81482383524443E-23  -1.64954160728590E-08  -1.64954766981173E-08  -2.32050795911692E-18
      1.11912808016913E-06
      0.00000000000000E+00  -1.46158041002570E-11   0.00000000000000E+00  -1.88789692596687E-14   5.35276936706626E-23
      1.46158276004462E-08   1.46158087214770E-08  -6.90371893170898E-19  -3.10535802009932E-01  -3.10535802009887E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.50817610417499E-11   0.00000000000000E+00  -4.50817610417499E-11
      2.80801466767487E-18  -4.45730915588692E-02  -3.99823705037488E-02   0.00000000000000E+00   1.25780675911964E-13
     -5.03606032943732E-23  -1.45708527411111E-08  -1.45707269604352E-08  -2.11764277450397E-18
      1.12412808016913E-06
      0.00000000000000E+00  -1.04930775364855E-11   0.00000000000000E+00  -4.05229193276934E-14   2.35538315150420E-23
      1.04931627669352E-08   1.04931222440159E-08  -6.65242618191316E-19  -3.23806809694491E-01  -3.23806809694458E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.28225408549997E-11   0.00000000000000E+00  -3.28225408549997E-11
      2.64390196339987E-18  -2.13831425724024E-02  -1.80874624482474E-02   0.00000000000000E+00   9.45315077759041E-14
     -2.35618406009462E-23  -1.04603942346686E-08  -1.04602997031609E-08  -1.97865934520855E-18
      1.12912808016913E-06
      0.00000000000000E+00  -7.74618513608281E-12   0.00000000000000E+00  -2.69356061397784E-14   1.23602443850468E-23
      7.74621587680697E-09   7.74618894120085E-09  -6.37993183095028E-19  -3.36478470835947E-01  -3.36478470835924E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.28895433333392E-11   0.00000000000000E+00  -2.28895433333392E-11
      2.52945424673317E-18  -1.22552479295691E-02  -9.82189851281262E-03   0.00000000000000E+00   5.56192858506941E-14
     -1.24185418931904E-23  -7.72335501715335E-09  -7.72329939786751E-09  -1.89146106363815E-18
      1.13412808016913E-06
      0.00000000000000E+00  -6.64579333959943E-12   0.00000000000000E+00  -1.07031597516031E-14   7.85355234003406E-24
      6.64576137541555E-09   6.64575067225581E-09  -6.10371993696778E-19  -3.48551245244993E-01  -3.48551245244975E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.83722102496564E-11   0.00000000000000E+00  -1.83722102496564E-11
      2.43759319548489E-18  -8.74529027345702E-03  -6.65722610209294E-03   0.00000000000000E+00   3.00391599207995E-14
     -8.81970192890742E-24  -6.62740850116606E-09  -6.62737846200615E-09  -1.82722120178812E-18
      1.13912808016913E-06
      0.00000000000000E+00  -6.27924099340419E-12   0.00000000000000E+00  -3.47835287669133E-15   5.86085725777131E-24
      6.27919225786226E-09   6.27918877950939E-09  -5.83219662105483E-19  -3.60035837519739E-01  -3.60035837519723E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.64561161544840E-11   0.00000000000000E+00  -1.64561161544840E-11
      2.35531261471247E-18  -7.12326999969653E-03  -5.15009176137697E-03   0.00000000000000E+00   1.89900340167825E-14
     -6.92224372081412E-24  -6.26275165338891E-09  -6.26273266335490E-09  -1.77209295260699E-18
      1.14412808016913E-06
      0.00000000000000E+00  -6.15249525605780E-12   0.00000000000000E+00  -1.12510462334303E-15   4.69203816629287E-24
      6.15249249913207E-09   6.15249137402745E-09  -5.56891739080360E-19  -3.70941463447945E-01  -3.70941463447930E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.54420567535074E-11   0.00000000000000E+00  -1.54420567535074E-11
      2.27810233094493E-18  -6.16946109244914E-03  -4.23588004603206E-03   0.00000000000000E+00   1.44710519807463E-14
     -5.73350942457639E-24  -6.13706378832593E-09  -6.13704931727395E-09  -1.72121059186457E-18
      1.14912808016913E-06
      0.00000000000000E+00  -6.09711287952166E-12   0.00000000000000E+00  -4.34246437312572E-16   3.90405705045252E-24
      6.09714658380459E-09   6.09714614955815E-09  -5.31643207253357E-19  -3.81252389190248E-01  -3.81252389190234E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.47029200251589E-11   0.00000000000000E+00  -1.47029200251589E-11
      2.20458773081914E-18  -5.51685846047862E-03  -3.60048072903229E-03   0.00000000000000E+00   1.21419880566826E-14
     -4.88508943363252E-24  -6.08245537152105E-09  -6.08244322953300E-09  -1.67294452356578E-18
      1.15412808016913E-06
      0.00000000000000E+00  -6.06496722149903E-12   0.00000000000000E+00  -2.18284409025734E-16   3.34207202196775E-24
      6.06492725986524E-09   6.06492704158083E-09  -5.07853703197076E-19  -3.90877505225969E-01  -3.90877505225955E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.39366482953308E-11   0.00000000000000E+00  -1.39366482953308E-11
      2.13490448934249E-18  -5.04229266755452E-03  -3.13582359816970E-03   0.00000000000000E+00   1.04562129432686E-14
     -4.25214098711049E-24  -6.05100084949844E-09  -6.05099039328551E-09  -1.62705078614541E-18
      1.15912808016913E-06
      0.00000000000000E+00  -6.04154681351111E-12   0.00000000000000E+00  -4.93950685333981E-16   2.93533029672524E-24
      6.04158639729561E-09   6.04158590334493E-09  -4.86261328804070E-19  -3.99566412910019E-01  -3.99566412910006E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.28204533929957E-11   0.00000000000000E+00  -1.28204533929957E-11
      2.07080222237751E-18  -4.69400958741670E-03  -2.79454183363345E-03   0.00000000000000E+00   9.20502382522049E-15
     -3.78370555874660E-24  -6.02877465497575E-09  -6.02876544995193E-09  -1.58454089357344E-18
      1.16412808016913E-06
      0.00000000000000E+00  -6.02161650553708E-12   0.00000000000000E+00  -1.28491999737206E-16   2.64678398465205E-24
      6.02157404494453E-09   6.02157391645254E-09  -4.68136149192924E-19  -4.06841942765044E-01  -4.06841942765033E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.09416540779636E-11   0.00000000000000E+00  -1.09416540779636E-11
      2.01609395198769E-18  -4.44684505870880E-03  -2.55308985290126E-03   0.00000000000000E+00   7.06451711743402E-15
     -3.45729794562978E-24  -6.01063932689169E-09  -6.01063226237457E-09  -1.54795780279477E-18
      1.16912808016913E-06
      0.00000000000000E+00  -6.00159435282584E-12   0.00000000000000E+00  -1.49589385089061E-16   2.45768809910413E-24
      6.00163939291328E-09   6.00163924332390E-09  -4.55361621826659E-19  -4.11966512573765E-01  -4.11966512573757E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.83266110631822E-12   0.00000000000000E+00  -7.83266110631822E-12
      1.97693064645610E-18  -4.28993466131963E-03  -2.40148018538823E-03   0.00000000000000E+00   4.83646970388500E-15
     -3.26798076966269E-24  -5.99381141868728E-09  -5.99380658221758E-09  -1.52156902462944E-18
      1.17412808016913E-06
      0.00000000000000E+00  -5.97890870273558E-12   0.00000000000000E+00  -2.06148404320785E-16   2.36234612814467E-24
      5.97892060259794E-09   5.97892039644954E-09  -4.50420204823004E-19  -4.13948909024495E-01  -4.13948909024492E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.06429771840232E-12   0.00000000000000E+00  -3.06429771840232E-12
      1.96160915786409E-18  -4.22444322939967E-03  -2.34164417996726E-03   0.00000000000000E+00   1.94990042751103E-15
     -3.23066025027539E-24  -5.97585804863156E-09  -5.97585609873113E-09  -1.51118895304108E-18
      1.17912808016913E-06
      0.00000000000000E+00  -5.94979392104079E-12   0.00000000000000E+00  -3.08118467859706E-16   2.36839641431995E-24
      5.94977189458089E-09   5.94977158646243E-09  -4.56245631530858E-19  -4.11611569181931E-01  -4.11611569181934E-01
      0.00000000000000E+00   0.00000000000000E+00   3.58966176048684E-12   0.00000000000000E+00   3.58966176048684E-12
      1.97955746666652E-18  -4.26769992760711E-03  -2.39198849078718E-03   0.00000000000000E+00  -1.85203557880147E-15
     -3.39454376992336E-24  -5.95335939618734E-09  -5.95336124822292E-09  -1.52331183513566E-18
      1.18412808016913E-06
      0.00000000000000E+00  -5.90772903139974E-12   0.00000000000000E+00  -4.87061158110998E-16   2.50254472637172E-24
      5.90775988181745E-09   5.90775939475630E-09  -4.75901239584542E-19  -4.03726841387400E-01  -4.03726841387412E-01
      0.00000000000000E+00   0.00000000000000E+00   1.19638976945967E-11   0.00000000000000E+00   1.19638976945967E-11
      2.03937695513951E-18  -4.46740910400699E-03  -2.60229665081097E-03   0.00000000000000E+00  -6.90088881882537E-15
     -3.88412846477129E-24  -5.91971639156207E-09  -5.91972329245090E-09  -1.56347571555496E-18
      1.18912808016913E-06
      0.00000000000000E+00  -5.83820256533365E-12   0.00000000000000E+00  -8.21806167480022E-16   2.82449600195282E-24
      5.83818264636965E-09   5.83818182456349E-09  -5.12117001328874E-19  -3.89165189895079E-01  -3.89165189895100E-01
      0.00000000000000E+00   0.00000000000000E+00   2.14788168087345E-11   0.00000000000000E+00   2.14788168087345E-11
      2.14677103918318E-18  -4.94146978953944E-03  -3.09528260619592E-03   0.00000000000000E+00  -1.37216836030515E-14
     -5.01821616719362E-24  -5.85964691968860E-09  -5.85966064137221E-09  -1.63465403785430E-18
      1.19412808016913E-06
      0.00000000000000E+00  -5.70208866479209E-12   0.00000000000000E+00  -2.76762145464456E-15   3.45094287335466E-24
      5.70207135029377E-09   5.70206858267232E-09  -5.66570862541629E-19  -3.66999721929703E-01  -3.66999721929734E-01
      0.00000000000000E+00   0.00000000000000E+00   3.14697365991305E-11   0.00000000000000E+00   3.14697365991305E-11
      2.30411972217883E-18  -5.99019374103930E-03  -4.18374566194143E-03   0.00000000000000E+00  -2.19546502462419E-14
     -7.66372551839987E-24  -5.73351636462120E-09  -5.73353831927145E-09  -1.73754885963720E-18
      1.19912808016913E-06
      0.00000000000000E+00  -5.39321481356318E-12   0.00000000000000E+00  -3.41083221868947E-15   4.56164913846139E-24
      5.39324958184111E-09   5.39324617100889E-09  -6.38635554726289E-19  -3.36573227471589E-01  -3.36573227471631E-01
      0.00000000000000E+00   0.00000000000000E+00   4.21086424399595E-11   0.00000000000000E+00   4.21086424399595E-11
      2.51466293437863E-18  -8.40243104896931E-03  -6.68993479847346E-03   0.00000000000000E+00  -3.64028543299048E-14
     -1.41742176672152E-23  -5.43531841059452E-09  -5.43535481344887E-09  -1.87602737965234E-18
      1.20412808016913E-06
      0.00000000000000E+00  -4.66892721594462E-12   0.00000000000000E+00  -6.69575651820194E-15   6.16821964307708E-24
      4.66892939393657E-09   4.66892269818006E-09  -7.24261740772061E-19  -2.97599176402011E-01  -2.97599176402067E-01
      0.00000000000000E+00   0.00000000000000E+00   5.55144543066555E-11   0.00000000000000E+00   5.55144543066555E-11
      2.79223520591191E-18  -1.40709538591170E-02  -1.25824489407286E-02   0.00000000000000E+00  -5.60042113392410E-14
     -2.94462466265995E-23  -4.72438114827534E-09  -4.72443715248671E-09  -2.06797346513984E-18
      1.20912808016913E-06
      0.00000000000000E+00  -3.27004002353678E-12   0.00000000000000E+00  -1.44987726026037E-14   6.64497396764043E-24
      3.27012841332531E-09   3.27011391455272E-09  -8.18388183844256E-19  -2.50464834476762E-01  -2.50464834476835E-01
      0.00000000000000E+00   0.00000000000000E+00   7.27457608582518E-11   0.00000000000000E+00   7.27457608582518E-11
      3.15596401020316E-18  -2.60210977323099E-02  -2.49678844949477E-02   0.00000000000000E+00  -8.25070267841687E-14
     -5.55869620777060E-23  -3.34277716838413E-09  -3.34285967541097E-09  -2.33757582635891E-18
      1.21412808016913E-06
      0.00000000000000E+00  -1.61582446169202E-12   0.00000000000000E+00  -1.71794548363677E-14   3.46916793450219E-25
      1.61580657857217E-09   1.61578939911733E-09  -9.20220791732155E-19  -1.96868270790954E-01  -1.96868270791040E-01
      0.00000000000000E+00   0.00000000000000E+00   8.61860232431445E-11   0.00000000000000E+00   8.61860232431445E-11
      3.58689412641889E-18  -4.51813251476879E-02  -4.46450983833886E-02   0.00000000000000E+00  -1.26741919931460E-13
     -7.89563309350056E-23  -1.70184868044047E-09  -1.70197542236048E-09  -2.66667333468673E-18
      1.21912808016913E-06
      0.00000000000000E+00  -5.67967854891345E-13   0.00000000000000E+00  -1.15167407310949E-14  -1.44323826651542E-23
      5.68005774600655E-10   5.67994257859909E-10  -1.03174903473503E-18  -1.39776024154629E-01  -1.39776024154717E-01
      0.00000000000000E+00   0.00000000000000E+00   8.79916617619228E-11   0.00000000000000E+00   8.79916617619228E-11
      4.02685243522850E-18  -6.83838914097343E-02  -6.81772172891711E-02   0.00000000000000E+00  -1.90202906116183E-13
     -8.96168805359612E-23  -6.55795716715626E-10  -6.55985919621832E-10  -2.99510340049347E-18
      1.22412808016913E-06
      0.00000000000000E+00  -1.56136053252795E-13   0.00000000000000E+00  -5.24151282328094E-15  -2.91025350459391E-23
      1.56211762743832E-10   1.56206521230980E-10  -1.14835911760167E-18  -8.37360105957338E-02  -8.37360105958127E-02
      0.00000000000000E+00   0.00000000000000E+00   7.88852139837810E-11   0.00000000000000E+00   7.88852139837810E-11
      4.42127850514741E-18  -9.24696582489825E-02  -9.23955912010778E-02   0.00000000000000E+00  -2.64559836219145E-13
     -9.57790384725924E-23  -2.34827175378446E-10  -2.35091735214761E-10  -3.27291938754574E-18
      1.22912808016913E-06
      0.00000000000000E+00  -5.05146054641397E-14   0.00000000000000E+00  -2.15530068322168E-15  -3.50408778720752E-23
      5.04644977789929E-11   5.04623424782747E-11  -1.24091921382547E-18  -4.11232747808650E-02  -4.11232747809230E-02
      0.00000000000000E+00   0.00000000000000E+00   5.80858992985503E-11   0.00000000000000E+00   5.80858992985503E-11
      4.71170800164016E-18  -1.15998514337526E-01  -1.15964315761100E-01   0.00000000000000E+00  -2.86109330549258E-13
     -1.01315882563871E-22  -1.08262132446175E-10  -1.08548241776825E-10  -3.47078878781468E-18
      1.23412808016913E-06
      0.00000000000000E+00  -3.71971185690483E-14   0.00000000000000E+00  -6.75678587820925E-16  -3.19437680248966E-23
      3.71830478679825E-11   3.71823721893628E-11  -1.28860114952106E-18  -1.99375369131704E-02  -1.99375369132043E-02
      0.00000000000000E+00   0.00000000000000E+00   3.39458992361502E-11   0.00000000000000E+00   3.39458992361502E-11
      4.88143749782091E-18  -1.38572099281530E-01  -1.38549690189371E-01   0.00000000000000E+00  -2.22042137854073E-13
     -1.05151184676762E-22  -7.09062292875536E-11  -7.11282714255128E-11  -3.59283634829985E-18
      1.23912808016913E-06
      0.00000000000000E+00  -4.02279948968967E-14   0.00000000000000E+00  -1.28579660009327E-16  -2.05228463584727E-23
      4.02299993011425E-11   4.02298707214620E-11  -1.30739833915840E-18  -1.17149751896700E-02  -1.17149751896891E-02
      0.00000000000000E+00   0.00000000000000E+00   1.91673757870837E-11   0.00000000000000E+00   1.91673757870837E-11
      4.97727437675632E-18  -1.60112854989577E-01  -1.60094141941563E-01   0.00000000000000E+00  -1.67806991758178E-13
     -1.07793927424936E-22  -5.92294395166793E-11  -5.93972465085453E-11  -3.66987603759793E-18
      1.24412808016913E-06
      0.00000000000000E+00  -4.42691633340279E-14   0.00000000000000E+00   1.46892981831129E-15  -1.07967030057664E-24
      4.42796942855324E-11   4.42811632153496E-11  -1.31397563022979E-18  -8.51761282211649E-03  -8.51761282212884E-03
      0.00000000000000E+00   0.00000000000000E+00   1.23550582677892E-11   0.00000000000000E+00   1.23550582677892E-11
      5.03904966809527E-18  -1.80627861988300E-01  -1.80610019392332E-01   0.00000000000000E+00  -1.47127547381068E-13
     -1.09946741592465E-22  -5.64890939356482E-11  -5.66362214831392E-11  -3.72507403786548E-18
      1.24912808016913E-06
      0.00000000000000E+00  -4.75755738734989E-14   0.00000000000000E+00   3.18281119745332E-17   2.17433397379721E-23
      4.76148910740856E-11   4.76149229022193E-11  -1.31611542677875E-18  -7.00052048461125E-03  -7.00052048462059E-03
      0.00000000000000E+00   0.00000000000000E+00   9.33925907856611E-12   0.00000000000000E+00   9.33925907856611E-12
      5.08574596348810E-18  -2.00153192758583E-01  -2.00135249647748E-01   0.00000000000000E+00  -1.37708265353988E-13
     -1.11880177307357E-22  -5.68164737153195E-11  -5.69541819807854E-11  -3.76963053670935E-18
      1.25412808016913E-06
      0.00000000000000E+00  -5.05146054641397E-14   0.00000000000000E+00   3.28906165244312E-17   4.20524391140858E-23
      5.05026631931405E-11   5.05026960837990E-11  -1.31664083063675E-18  -6.08912104454285E-03  -6.08912104455072E-03
      0.00000000000000E+00   0.00000000000000E+00   7.86496515768727E-12   0.00000000000000E+00   7.86496515768727E-12
      5.12507078927654E-18  -2.18733350689754E-01  -2.18714962382109E-01   0.00000000000000E+00  -1.33166820350983E-13
     -1.13667098309689E-22  -5.82344944210216E-11  -5.83676612414863E-11  -3.80842995863979E-18
      1.25912808016913E-06
      0.00000000000000E+00  -5.32699475803655E-14   0.00000000000000E+00   3.33987865274743E-17   5.74535887517333E-23
      5.32449304715883E-11   5.32449638704322E-11  -1.31649479880249E-18  -5.45930584259293E-03  -5.45930584259995E-03
      0.00000000000000E+00   0.00000000000000E+00   7.01830827270902E-12   0.00000000000000E+00   7.01830827270902E-12
      5.16016233064009E-18  -2.36413226926347E-01  -2.36394241532524E-01   0.00000000000000E+00  -1.28919095601299E-13
     -1.15333807444222E-22  -6.01343530474248E-11  -6.02632721431414E-11  -3.84366753183759E-18
      1.26412808016913E-06
      0.00000000000000E+00  -5.60252896965913E-14   0.00000000000000E+00   3.51828004684558E-17   6.80746713954229E-23
      5.59844228013927E-11   5.59844579842613E-11  -1.31600435565460E-18  -4.99994072596090E-03  -4.99994072596735E-03
      0.00000000000000E+00   0.00000000000000E+00   6.44742948201738E-12   0.00000000000000E+00   6.44742948201738E-12
      5.19239947805017E-18  -2.53233991392434E-01  -2.53214322909816E-01   0.00000000000000E+00  -1.24511680315541E-13
     -1.16899229717274E-22  -6.23073757858462E-11  -6.24318874662786E-11  -3.87639512239558E-18
      1.26912808016913E-06
      0.00000000000000E+00  -5.87806318128171E-14   0.00000000000000E+00   3.74607153173715E-17   7.51986748732166E-23
      5.87685648692276E-11   5.87686023300181E-11  -1.31529670377142E-18  -4.66327663827064E-03  -4.66327663827664E-03
      0.00000000000000E+00   0.00000000000000E+00   6.00628504242691E-12   0.00000000000000E+00   6.00628504242691E-12
      5.22243090326231E-18  -2.69230165916347E-01  -2.69209759412278E-01   0.00000000000000E+00  -1.20036853444803E-13
     -1.18378516543127E-22  -6.46548505188819E-11  -6.47748873724451E-11  -3.90713419949089E-18
      1.27412808016913E-06
      0.00000000000000E+00  -6.16278186662505E-14   0.00000000000000E+00   3.98161872151311E-17   8.01281182276968E-23
      6.16105890351966E-11   6.16106288514640E-11  -1.31442579292345E-18  -4.42599301787568E-03  -4.42599301788132E-03
      0.00000000000000E+00   0.00000000000000E+00   5.62996285857347E-12   0.00000000000000E+00   5.62996285857347E-12
      5.25058071755517E-18  -2.84437724627623E-01  -2.84416541450278E-01   0.00000000000000E+00  -1.15659871640946E-13
     -1.19782630388118E-22  -6.71249318382766E-11  -6.72405917100373E-11  -3.93615492463173E-18
      1.27912808016913E-06
      0.00000000000000E+00  -6.45668502568913E-14   0.00000000000000E+00   4.23316215186990E-17   8.37919627907719E-23
      6.45228771525329E-11   6.45229194842383E-11  -1.31340972941388E-18  -4.27849809731118E-03  -4.27849809731647E-03
      0.00000000000000E+00   0.00000000000000E+00   5.28874908215874E-12   0.00000000000000E+00   5.28874908215874E-12
      5.27702446296597E-18  -2.98902014910580E-01  -2.98880021867806E-01   0.00000000000000E+00  -1.11532960577866E-13
     -1.21119973526626E-22  -6.97001356056979E-11  -6.98116685663969E-11  -3.96361473355208E-18
      1.28412808016913E-06
      0.00000000000000E+00  -6.75058818475322E-14   0.00000000000000E+00   4.54642168142975E-17   8.67666635619029E-23
      6.75373085598609E-11   6.75373540241645E-11  -1.31223707114638E-18  -4.22335357777977E-03  -4.22335357778474E-03
      0.00000000000000E+00   0.00000000000000E+00   4.96927297395243E-12   0.00000000000000E+00   4.96927297395243E-12
      5.30187082783573E-18  -3.12687361808189E-01  -3.12664519876721E-01   0.00000000000000E+00  -1.07814580268346E-13
     -1.22398408345903E-22  -7.23988124177264E-11  -7.25066269981171E-11  -3.98963375668935E-18
      1.28912808016913E-06
      0.00000000000000E+00  -7.07204476497956E-14   0.00000000000000E+00   5.01110197428854E-17   8.94012183868081E-23
      7.07237262775267E-11   7.07237763886358E-11  -1.31085697413719E-18  -4.28017689284547E-03  -4.28017689285012E-03
      0.00000000000000E+00   0.00000000000000E+00   4.65514223607872E-12   0.00000000000000E+00   4.65514223607872E-12
      5.32514653901613E-18  -3.25863133922637E-01  -3.25839387240670E-01   0.00000000000000E+00  -1.04450718655241E-13
     -1.23623820746276E-22  -7.52744679059354E-11  -7.53789186247143E-11  -4.01428956487894E-18
      1.29412808016913E-06
      0.00000000000000E+00  -7.42105476636816E-14   0.00000000000000E+00   5.79840280283148E-17   9.19308600321727E-23
      7.42210643688859E-11   7.42211223530058E-11  -1.30914764923871E-18  -4.50151964732281E-03  -4.50151964732710E-03
      0.00000000000000E+00   0.00000000000000E+00   4.29761358837569E-12   0.00000000000000E+00   4.29761358837569E-12
      5.34663460695800E-18  -3.38439189233207E-01  -3.38414453526792E-01   0.00000000000000E+00  -1.00612085718054E-13
     -1.24791878502627E-22  -7.84181238555386E-11  -7.85187359413815E-11  -4.03748695771929E-18
      1.29912808016913E-06
      0.00000000000000E+00  -7.83435608380203E-14   0.00000000000000E+00   7.37953604372782E-17   9.46229370844835E-23
      7.83763307251775E-11   7.83764045206326E-11  -1.30680991944535E-18  -5.01727069687833E-03  -5.01727069688216E-03
      0.00000000000000E+00   0.00000000000000E+00   3.82906552966164E-12   0.00000000000000E+00   3.82906552966164E-12
      5.36577993460631E-18  -3.50417503795740E-01  -3.50391606775890E-01   0.00000000000000E+00  -9.54964631778090E-14
     -1.25889090347420E-22  -8.21099735869906E-11  -8.22054700502943E-11  -4.05897001516096E-18
      1.30412808016913E-06
      0.00000000000000E+00  -8.41297792820945E-14   0.00000000000000E+00   1.12619259864184E-16   9.80118392129882E-23
      8.41298832967302E-11   8.41299959160881E-11  -1.30307547829753E-18  -6.15994462958406E-03  -6.15994462958714E-03
      0.00000000000000E+00   0.00000000000000E+00   3.08446648664157E-12   0.00000000000000E+00   3.08446648664157E-12
      5.38120226703952E-18  -3.61809656054907E-01  -3.61782181181928E-01   0.00000000000000E+00  -8.72186190241536E-14
     -1.26880661260618E-22  -8.71272437835790E-11  -8.72144624027300E-11  -4.07812678874199E-18
      1.30912808016913E-06
      0.00000000000000E+00  -9.42327003749225E-14   0.00000000000000E+00   2.03460344819841E-16   1.03431660850753E-22
      9.42051807176465E-11   9.42053841780947E-11  -1.29591877933732E-18  -8.80188137241691E-03  -8.80188137241852E-03
      0.00000000000000E+00   0.00000000000000E+00   1.61065854544166E-12   0.00000000000000E+00   1.61065854544166E-12
      5.38925555976673E-18  -3.72622857391268E-01  -3.72592672915141E-01   0.00000000000000E+00  -7.04148322042218E-14
     -1.27671745083408E-22  -9.57456278912041E-11  -9.58160427235360E-11  -4.09333678042941E-18
      1.31412808016913E-06
      0.00000000000000E+00  -1.16459126779144E-13   0.00000000000000E+00   4.39121222911943E-16   1.13830807832815E-22
      1.16497190804667E-10   1.16497629926003E-10  -1.28051427231577E-18  -1.49876644727702E-02  -1.49876644727686E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.61669320414012E-12   0.00000000000000E+00  -1.61669320414012E-12
      5.38117209374603E-18  -3.82833811817123E-01  -3.82797621541068E-01   0.00000000000000E+00  -3.35320326804844E-14
     -1.28037961125770E-22  -1.14847404689055E-10  -1.14880936721864E-10  -4.10065782143026E-18
      1.31912808016913E-06
      0.00000000000000E+00  -1.70923055943207E-13   0.00000000000000E+00   9.57130441174713E-16   1.32281365002277E-22
      1.70903274912901E-10   1.70904232043475E-10  -1.24937444757062E-18  -2.77420750491645E-02  -2.77420750491568E-02
      0.00000000000000E+00   0.00000000000000E+00  -7.66024197134487E-12   0.00000000000000E+00  -7.66024197134487E-12
      5.34287088388930E-18  -3.92332029316449E-01  -3.92280603559220E-01   0.00000000000000E+00   3.14970829693029E-14
     -1.27663542040957E-22  -1.63275487154971E-10  -1.63243990072129E-10  -4.09349643631868E-18
      1.32412808016913E-06
      0.00000000000000E+00  -2.93443935378048E-13   0.00000000000000E+00   1.80254947705357E-15   1.54583656815454E-22
      2.93438104380098E-10   2.93439906929730E-10  -1.20067409994149E-18  -4.75186359997257E-02  -4.75186359997108E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.48689659199694E-11   0.00000000000000E+00  -1.48689659199694E-11
      5.26852605428946E-18  -4.00834526518603E-01  -4.00746769734796E-01   0.00000000000000E+00   9.53154573559390E-14
     -1.26557581155112E-22  -2.78666256466990E-10  -2.78570941009761E-10  -4.06785195434797E-18
      1.32912808016913E-06
      0.00000000000000E+00  -5.33342388964108E-13   0.00000000000000E+00   2.99703303656854E-15   1.72594395986638E-22
      5.33373803605471E-10   5.33376800638680E-10  -1.14293687797458E-18  -7.09334213575190E-02  -7.09334213574989E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.01000091487997E-11   0.00000000000000E+00  -2.01000091487997E-11
      5.16802600854546E-18  -4.07824222628879E-01  -4.07662526737064E-01   0.00000000000000E+00   1.23533787793260E-13
     -1.25112267985153E-22  -5.13400325277548E-10  -5.13276791489880E-10  -4.02508913057087E-18
      1.33412808016913E-06
      0.00000000000000E+00  -9.51511477469977E-13   0.00000000000000E+00   4.73953517847597E-15   1.85548290782360E-22
      9.51511211868056E-10   9.51515951403420E-10  -1.08529714109952E-18  -9.50025371469813E-02  -9.50025371469579E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.33516335348863E-11   0.00000000000000E+00  -2.33516335348863E-11
      5.05126784087102E-18  -4.12521360179724E-01  -4.12228961864508E-01   0.00000000000000E+00   1.29587312902800E-13
     -1.23566023143646E-22  -9.28293905181313E-10  -9.28164317868534E-10  -3.96597069977150E-18
      1.33912808016913E-06
      0.00000000000000E+00  -1.60939533008749E-12   0.00000000000000E+00   6.99867009388642E-15   1.95528377800195E-22
      1.60937307518032E-09   1.60938007385061E-09  -1.03232352979484E-18  -1.18439345087058E-01  -1.18439345087032E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.59746701098306E-11   0.00000000000000E+00  -2.59746701098306E-11
      4.92139449032187E-18  -4.13898729743086E-01  -4.13399908637947E-01   0.00000000000000E+00   1.33849994846853E-13
     -1.21927917801480E-22  -1.58353925373550E-09  -1.58340540374078E-09  -3.88907096052703E-18
      1.34412808016913E-06
      0.00000000000000E+00  -2.55365107331807E-12   0.00000000000000E+00   9.75800756143328E-15   2.03291756433827E-22
      2.55360925069289E-09   2.55361900870065E-09  -9.84996231739559E-19  -1.40904836649736E-01  -1.40904836649707E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.87367408468352E-11   0.00000000000000E+00  -2.87367408468352E-11
      4.77771078608770E-18  -4.10760384408965E-01  -4.09964964068361E-01   0.00000000000000E+00   1.45215376713448E-13
     -1.20099811464955E-22  -2.52502748323041E-09  -2.52488226785382E-09  -3.79271455434813E-18
      1.34912808016913E-06
      0.00000000000000E+00  -3.80126998354512E-12   0.00000000000000E+00   1.26935074227860E-14   2.08380560280313E-22
      3.80123243328300E-09   3.80124512679063E-09  -9.42806495396053E-19  -1.62335741466960E-01  -1.62335741466929E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.16273524817932E-11   0.00000000000000E+00  -3.16273524817932E-11
      4.61957402367873E-18  -4.01885137849757E-01  -4.00697576329805E-01   0.00000000000000E+00   1.66145120438826E-13
     -1.17946940064566E-22  -3.76978391942916E-09  -3.76961777430884E-09  -3.67676752828268E-18
      1.35412808016913E-06
      0.00000000000000E+00  -5.33875088439911E-12   0.00000000000000E+00   1.55052131870671E-14   2.10117731204213E-22
      5.33870933924398E-09   5.33872484445738E-09  -9.04841938151960E-19  -1.82743868098823E-01  -1.82743868098789E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.43584275631966E-11   0.00000000000000E+00  -3.43584275631966E-11
      4.44778188586275E-18  -3.86170044127194E-01  -3.84498968403454E-01   0.00000000000000E+00   1.96680193067562E-13
     -1.15318429844103E-22  -5.30456309708714E-09  -5.30436641689419E-09  -3.54293994771078E-18
      1.35912808016913E-06
      0.00000000000000E+00  -7.13110093100400E-12   0.00000000000000E+00   1.79815746208674E-14   2.08245973145192E-22
      7.13108560836968E-09   7.13110358994450E-09  -8.70217347677611E-19  -2.02166844489085E-01  -2.02166844489048E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.66672419678742E-11   0.00000000000000E+00  -3.66672419678742E-11
      4.26444567602338E-18  -3.62726961762193E-01  -3.60491922966670E-01   0.00000000000000E+00   2.34625337428274E-13
     -1.12061117986490E-22  -7.09467097331394E-09  -7.09443634797662E-09  -3.39422832834576E-18
      1.36412808016913E-06
      0.00000000000000E+00  -9.12863212053050E-12   0.00000000000000E+00   1.99756291729204E-14   2.03326848147602E-22
      9.12863877759746E-09   9.12865875322683E-09  -8.38211364171112E-19  -2.20649471793188E-01  -2.20649471793149E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.84287508684069E-11   0.00000000000000E+00  -3.84287508684069E-11
      4.07230192168134E-18  -3.30948279516738E-01  -3.28084448196202E-01   0.00000000000000E+00   2.74323129853138E-13
     -1.08028410205424E-22  -9.09050432548817E-09  -9.09023000235843E-09  -3.23409055751023E-18
      1.36912808016913E-06
      0.00000000000000E+00  -1.12561236132056E-11   0.00000000000000E+00   2.12331884923347E-14   1.96532295956360E-22
      1.12560648882640E-08   1.12560861214526E-08  -8.08304977331937E-19  -2.38236423705392E-01  -2.38236423705352E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.97629347509755E-11   0.00000000000000E+00  -3.97629347509755E-11
      3.87348724792646E-18  -2.90625715834388E-01  -2.87092019644488E-01   0.00000000000000E+00   3.03695966484069E-13
     -1.03063800821246E-22  -1.12166268826681E-08  -1.12163231867017E-08  -3.06518227059452E-18
      1.37412808016913E-06
      0.00000000000000E+00  -1.33573475110394E-11   0.00000000000000E+00   2.09546829500446E-14   1.87436635480044E-22
      1.33572897110725E-08   1.33573106657556E-08  -7.80245191567912E-19  -2.54968253091053E-01  -2.54968253091012E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.12783463176220E-11   0.00000000000000E+00  -4.12783463176220E-11
      3.66709551633835E-18  -2.42307424718847E-01  -2.38112154834430E-01   0.00000000000000E+00   3.03064581202573E-13
     -9.70275750243146E-23  -1.33163353840191E-08  -1.33160323194380E-08  -2.88685032477044E-18
      1.37912808016913E-06
      0.00000000000000E+00  -1.51254505470215E-11   0.00000000000000E+00   1.76480679024946E-14   1.69537016478679E-22
      1.51254199050866E-08   1.51254375531547E-08  -7.54090915174299E-19  -2.70878917985242E-01  -2.70878917985198E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.40468595814256E-11   0.00000000000000E+00  -4.40468595814256E-11
      3.44686121843123E-18  -1.87939922404074E-01  -1.83188408159808E-01   0.00000000000000E+00   2.58887960499934E-13
     -9.03804285003002E-23  -1.50816495815336E-08  -1.50813906935732E-08  -2.69277030325693E-18
      1.38412808016913E-06
      0.00000000000000E+00  -1.62933482253525E-11   0.00000000000000E+00   1.17042126591546E-14   1.36865215721644E-22
      1.62932804696172E-08   1.62932921738300E-08  -7.29771523594676E-19  -2.86005483848263E-01  -2.86005483848216E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.71237458867467E-11   0.00000000000000E+00  -4.71237458867467E-11
      3.21124248899749E-18  -1.30614537863578E-01  -1.25496000943763E-01   0.00000000000000E+00   1.97638715743917E-13
     -8.47022222911755E-23  -1.62463660666590E-08  -1.62461684279433E-08  -2.48147096540282E-18
      1.38912808016913E-06
      0.00000000000000E+00  -1.63693956677603E-11   0.00000000000000E+00   9.08967659101229E-16   9.07024041804774E-23
      1.63693631697917E-08   1.63693640787595E-08  -7.07007842754731E-19  -3.00393977223972E-01  -3.00393977223923E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.82709342777426E-11   0.00000000000000E+00  -4.82709342777426E-11
      2.96988781760878E-18  -7.56105607607494E-02  -7.04683801226089E-02   0.00000000000000E+00   1.51083513332809E-13
     -7.31200518192021E-23  -1.63212442279950E-08  -1.63210931444817E-08  -2.26287997485405E-18
      1.39412808016913E-06
      0.00000000000000E+00  -1.35663861329238E-11   0.00000000000000E+00  -2.75320851637415E-14   4.35728660320601E-23
      1.35664133511657E-08   1.35663858190806E-08  -6.84023133648423E-19  -3.14112442268693E-01  -3.14112442268650E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.23807440453580E-11   0.00000000000000E+00  -4.23807440453580E-11
      2.75798409738199E-18  -3.64385078587306E-02  -3.21775677949836E-02   0.00000000000000E+00   1.18149652062574E-13
     -4.12144550227123E-23  -1.35241232246873E-08  -1.35240050750352E-08  -2.07396096373357E-18
      1.39912808016913E-06
      0.00000000000000E+00  -9.56140452225237E-12   0.00000000000000E+00  -3.93717793436966E-14   1.95268809892046E-23
      9.56143067973694E-09   9.56139130795762E-09  -6.58138187368828E-19  -3.27224794144505E-01  -3.27224794144475E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.95852867704884E-11   0.00000000000000E+00  -2.95852867704884E-11
      2.61005766352955E-18  -1.80322938449585E-02  -1.50291486031629E-02   0.00000000000000E+00   8.42229184391008E-14
     -1.79094116538157E-23  -9.53189024410554E-09  -9.53180602118712E-09  -1.95191947616072E-18
      1.40412808016913E-06
      0.00000000000000E+00  -7.33536362655354E-12   0.00000000000000E+00  -2.17988509904648E-14   1.06200415856645E-23
      7.33534061847075E-09   7.33531881961977E-09  -6.30657763973447E-19  -3.39737166452970E-01  -3.39737166452948E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.12779850519731E-11   0.00000000000000E+00  -2.12779850519731E-11
      2.50366773826968E-18  -1.10004493505803E-02  -8.69604268872389E-03   0.00000000000000E+00   4.70320637329785E-14
     -1.13469839076097E-23  -7.31408786663152E-09  -7.31404083456780E-09  -1.87300997429623E-18
      1.40912808016913E-06
      0.00000000000000E+00  -6.50591380483237E-12   0.00000000000000E+00  -8.03344405178190E-15   7.19375746019109E-24
      6.50591467168205E-09   6.50590663823800E-09  -6.03108816610575E-19  -3.51652722984390E-01  -3.51652722984373E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.77091973388398E-11   0.00000000000000E+00  -1.77091973388398E-11
      2.41512175157548E-18  -8.20759705464409E-03  -6.16338364751876E-03   0.00000000000000E+00   2.60575795079903E-14
     -8.20274144604852E-24  -6.48822349847866E-09  -6.48819744089916E-09  -1.81201293496491E-18
      1.41412808016913E-06
      0.00000000000000E+00  -6.23276755637718E-12   0.00000000000000E+00  -2.55880871389588E-15   5.49820329953476E-24
      6.23280274962934E-09   6.23280019082063E-09  -5.76149127073489E-19  -3.62983413607785E-01  -3.62983413607769E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.61366523137005E-11   0.00000000000000E+00  -1.61366523137005E-11
      2.33443849000698E-18  -6.82805708785922E-03  -4.86939328953617E-03   0.00000000000000E+00   1.74067996206372E-14
     -6.56039667986393E-24  -6.21668094530654E-09  -6.21666353850693E-09  -1.75828936293349E-18
      1.41912808016913E-06
      0.00000000000000E+00  -6.13394261914188E-12   0.00000000000000E+00  -8.54397618498083E-16   4.45485713606369E-24
      6.13394488396636E-09   6.13394402956875E-09  -5.50081257457157E-19  -3.73734777910632E-01  -3.73734777910617E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.52334530395424E-11   0.00000000000000E+00  -1.52334530395424E-11
      2.25827122480927E-18  -5.97429666733059E-03  -4.04649320036226E-03   0.00000000000000E+00   1.37351078778414E-14
     -5.48271785298548E-24  -6.11872431163708E-09  -6.11871057652921E-09  -1.70818996735211E-18
      1.42412808016913E-06
      0.00000000000000E+00  -6.08719364790325E-12   0.00000000000000E+00  -3.52441839687325E-16   3.73681872194675E-24
      6.08721666007909E-09   6.08721630763725E-09  -5.25172014393196E-19  -3.83877709576253E-01  -3.83877709576238E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.45139951955760E-11   0.00000000000000E+00  -1.45139951955760E-11
      2.18570124883139E-18  -5.37653019516141E-03  -3.46322119978307E-03   0.00000000000000E+00   1.16636268445819E-14
     -4.69913495671989E-24  -6.07271397606852E-09  -6.07270231244168E-09  -1.66052923443819E-18
      1.42912808016913E-06
      0.00000000000000E+00  -6.05817071094567E-12   0.00000000000000E+00  -1.90509986219117E-16   3.22105750602763E-24
      6.05817606271594E-09   6.05817587220595E-09  -5.01873339600251E-19  -3.93287492715838E-01  -3.93287492715825E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.36903834291697E-11   0.00000000000000E+00  -1.36903834291697E-11
      2.11724933168554E-18  -4.93900710205255E-03  -3.03458725231840E-03   0.00000000000000E+00   1.00387724134785E-14
     -4.11319577705928E-24  -6.04449552754918E-09  -6.04448548877677E-09  -1.61537599208529E-18
      1.43412808016913E-06
      0.00000000000000E+00  -6.03612797401587E-12   0.00000000000000E+00  -1.35645537546234E-16   2.84834583468775E-24
      6.03610947404650E-09   6.03610933840097E-09  -4.81051942827037E-19  -4.01658570074389E-01  -4.01658570074377E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.24154183612848E-11   0.00000000000000E+00  -1.24154183612848E-11
      2.05517223987911E-18  -4.61928860768778E-03  -2.72141862245799E-03   0.00000000000000E+00   8.41385400061896E-15
     -3.68382744228387E-24  -6.02370233389368E-09  -6.02369392003968E-09  -1.57412029705208E-18
      1.43912808016913E-06
      0.00000000000000E+00  -6.01638135551625E-12   0.00000000000000E+00  -1.29954241967912E-16   2.58740952047352E-24
      6.01639799954705E-09   6.01639786959281E-09  -4.64135624204471E-19  -4.08446821446940E-01  -4.08446821446929E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02569072812998E-11   0.00000000000000E+00  -1.02569072812998E-11
      2.00388770347262E-18  -4.39662234175350E-03  -2.50428204169035E-03   0.00000000000000E+00   6.52435583393312E-15
     -3.39354062359319E-24  -6.00614748666735E-09  -6.00614096231152E-09  -1.53975207926814E-18
      1.44412808016913E-06
      0.00000000000000E+00  -5.99599182385618E-12   0.00000000000000E+00  -1.60911881731742E-16   2.42321612836804E-24
      5.99601411021219E-09   5.99601394930031E-09  -4.53172938868954E-19  -4.12844565101321E-01  -4.12844565101314E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.74500406907909E-12   0.00000000000000E+00  -6.74500406907909E-12
      1.97016268312722E-18  -4.26329554396974E-03  -2.37627064688315E-03   0.00000000000000E+00   4.14525796810695E-15
     -3.24203589106468E-24  -5.98927309048919E-09  -5.98926894523123E-09  -1.51698974425827E-18
      1.44912808016913E-06
      0.00000000000000E+00  -5.97202034744501E-12   0.00000000000000E+00  -2.28038129593703E-16   2.35337568962575E-24
      5.97201144572222E-09   5.97201121768409E-09  -4.50787080094200E-19  -4.13801642104421E-01  -4.13801642104420E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.48574485157109E-12   0.00000000000000E+00  -1.48574485157109E-12
      1.96273395886937E-18  -4.22406502392367E-03  -2.34294549469386E-03   0.00000000000000E+00   1.04312984571351E-15
     -3.25122814053473E-24  -5.97052651596237E-09  -5.97052547283253E-09  -1.51194687877517E-18
      1.45412808016913E-06
      0.00000000000000E+00  -5.94024206837121E-12   0.00000000000000E+00  -3.46225367728794E-16   2.38975266024210E-24
      5.94027501311493E-09   5.94027466688957E-09  -4.59984006795069E-19  -4.10111958990596E-01  -4.10111958990602E-01
      0.00000000000000E+00   0.00000000000000E+00   5.65911508229189E-12   0.00000000000000E+00   5.65911508229189E-12
      1.99102953428082E-18  -4.30229414594120E-03  -2.42892300249148E-03   0.00000000000000E+00  -3.05169623164674E-15
     -3.48447813025704E-24  -5.94593073027562E-09  -5.94593378197185E-09  -1.53104552748576E-18
      1.45912808016913E-06
      0.00000000000000E+00  -5.89294202870933E-12   0.00000000000000E+00  -5.55778553578821E-16   2.56601291114932E-24
      5.89296464855934E-09   5.89296409278079E-09  -4.83789805067097E-19  -4.00560722124474E-01  -4.00560722124488E-01
      0.00000000000000E+00   0.00000000000000E+00   1.44051309587952E-11   0.00000000000000E+00   1.44051309587952E-11
      2.06305518907480E-18  -4.55867902222630E-03  -2.69745924706413E-03   0.00000000000000E+00  -8.50707108943460E-15
     -4.10070020948537E-24  -5.90736071666849E-09  -5.90736922373959E-09  -1.57926538400770E-18
      1.46412808016913E-06
      0.00000000000000E+00  -5.81120021259463E-12   0.00000000000000E+00   1.90848074966323E-15   2.95433377521766E-24
      5.81122668163952E-09   5.81122859012027E-09  -5.24743239690766E-19  -3.84064062663444E-01  -3.84064062663468E-01
      0.00000000000000E+00   0.00000000000000E+00   2.40991087530728E-11   0.00000000000000E+00   2.40991087530728E-11
      2.18355073284016E-18  -5.14355709561852E-03  -3.30503787831542E-03   0.00000000000000E+00  -1.87943539866315E-14
     -5.51320749046000E-24  -5.83530890451935E-09  -5.83532769887334E-09  -1.65880749314940E-18
      1.46912808016913E-06
      0.00000000000000E+00  -5.64404279087693E-12   0.00000000000000E+00  -1.91661894849238E-15   3.69033223682732E-24
      5.64408421121141E-09   5.64408229459247E-09  -5.84057413767322E-19  -3.59760509508733E-01  -3.59760509508767E-01
      0.00000000000000E+00   0.00000000000000E+00   3.41779248514306E-11   0.00000000000000E+00   3.41779248514306E-11
      2.35444035709732E-18  -6.44461173968147E-03  -4.65558119930385E-03   0.00000000000000E+00  -2.62267806158181E-14
     -8.85840591424196E-24  -5.67823399266328E-09  -5.67826021944390E-09  -1.77038294332999E-18
      1.47412808016913E-06
      0.00000000000000E+00  -5.25535586301468E-12   0.00000000000000E+00  -4.23866594968191E-15   4.95410649401040E-24
      5.25534742482555E-09   5.25534318615960E-09  -6.60243440357458E-19  -3.27076946869439E-01  -3.27076946869484E-01
      0.00000000000000E+00   0.00000000000000E+00   4.52666428737060E-11   0.00000000000000E+00   4.52666428737060E-11
      2.58077357146585E-18  -9.47410797466039E-03  -7.80406656137882E-03   0.00000000000000E+00  -4.07393321096420E-14
     -1.71252220098350E-23  -5.30056908970118E-09  -5.30060982903331E-09  -1.92053013110839E-18
      1.47912808016913E-06
      0.00000000000000E+00  -4.36620696210861E-12   0.00000000000000E+00  -9.34007696480475E-15   6.56158660252891E-24
      4.36616916891876E-09   4.36615982884180E-09  -7.48514014188096E-19  -2.85861880809334E-01  -2.85861880809394E-01
      0.00000000000000E+00   0.00000000000000E+00   5.98318542639884E-11   0.00000000000000E+00   5.98318542639884E-11
      2.87993284278579E-18  -1.65068945656511E-02  -1.51124206590925E-02   0.00000000000000E+00  -6.11945617485542E-14
     -3.55422797742351E-23  -4.42593048854400E-09  -4.42599168310578E-09  -2.13141882859769E-18
      1.48412808016913E-06
      0.00000000000000E+00  -2.81458197172466E-12   0.00000000000000E+00  -1.60613190787134E-14   5.90891735971573E-24
      2.81459441374872E-09   2.81457835242965E-09  -8.44543936186972E-19  -2.36781391782322E-01  -2.36781391782399E-01
      0.00000000000000E+00   0.00000000000000E+00   7.71713907972260E-11   0.00000000000000E+00   7.71713907972260E-11
      3.26578979677192E-18  -3.04800064732820E-02  -2.95689229983826E-02   0.00000000000000E+00  -9.22559493875066E-14
     -6.28885452396447E-23  -2.89165748727743E-09  -2.89174974322688E-09  -2.42124586058495E-18
      1.48912808016913E-06
      0.00000000000000E+00  -1.26167115501979E-12   0.00000000000000E+00  -1.68062907317952E-14  -2.93031078300528E-24
      1.26172169050087E-09   1.26170488421014E-09  -9.48786977020630E-19  -1.81943962144771E-01  -1.81943962144858E-01
      0.00000000000000E+00   0.00000000000000E+00   8.78456337280652E-11   0.00000000000000E+00   8.78456337280652E-11
      3.70501796541225E-18  -5.10979873789400E-02  -5.06727968179909E-02   0.00000000000000E+00  -1.41278275298859E-13
     -8.27403129984758E-23  -1.34940923966282E-09  -1.34955051793820E-09  -2.75623098839161E-18
      1.49412808016913E-06
      0.00000000000000E+00  -4.11005199003682E-13   0.00000000000000E+00  -9.34611340143199E-15  -1.87792351888199E-23
      4.11043248706017E-10   4.11033902592597E-10  -1.06277186527172E-18  -1.24526050018099E-01  -1.24526050018186E-01
      0.00000000000000E+00   0.00000000000000E+00   8.65871882177479E-11   0.00000000000000E+00   8.65871882177479E-11
      4.13795390650098E-18  -7.47679153759080E-02  -7.46111359395810E-02   0.00000000000000E+00  -2.09827266950928E-13
     -9.13322405113711E-23  -4.97411263543303E-10  -4.97621090810345E-10  -3.07518204122926E-18
      1.49912808016913E-06
      0.00000000000000E+00  -1.10029995174617E-13   0.00000000000000E+00  -4.28963713323698E-15  -3.16895558130900E-23
      1.09991297326741E-10   1.09987007689576E-10  -1.17695653900153E-18  -7.04252768276404E-02  -7.04252768277149E-02
      0.00000000000000E+00   0.00000000000000E+00   7.45660270373087E-11   0.00000000000000E+00   7.45660270373087E-11
      4.51078404168753E-18  -9.87869059333962E-02  -9.87287614729652E-02   0.00000000000000E+00  -2.79927827033833E-13
     -9.73587520761050E-23  -1.84273106899754E-10  -1.84553034726885E-10  -3.33382750268600E-18
      1.50000000000000E-06
      0.00000000000000E+00  -8.65177424494902E-14   0.00000000000000E+00  -2.71557610944248E-15  -3.28977394592181E-23
      8.64722301721932E-11   8.64695145960509E-11  -1.19608992405336E-18  -6.14052317464314E-02  -6.14052317465012E-02
      0.00000000000000E+00   0.00000000000000E+00   6.97620860860754E-11   0.00000000000000E+00   6.97620860860754E-11
      4.57161098798875E-18  -1.02963106255654E-01  -1.02913884652496E-01   0.00000000000000E+00  -3.14299924517092E-13
     -9.84368631375048E-23  -1.55917300757511E-10  -1.56231600682126E-10  -3.37552106393539E-18
}
